/*
 * Decompiled with CFR 0.152.
 */
package cn.jslim.basic.toolkit.domain;

import cn.jslim.basic.toolkit.domain.LogicException;
import cn.jslim.basic.toolkit.domain.Result;
import cn.jslim.basic.toolkit.domain.ResultStatus;
import com.alibaba.fastjson2.JSONObject;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LogicAssert {
    public static void isNull(Object value, ResultStatus error) throws LogicException {
        LogicAssert.isNull(value, error, null);
    }

    public static void isNull(Object value, String message) throws LogicException {
        if (value == null) {
            throw LogicException.of(ResultStatus.PARAMETER_EMPTY, message);
        }
    }

    public static void isNull(Object value, ResultStatus error, String message) throws LogicException {
        if (value == null) {
            throw LogicException.of(error, message);
        }
    }

    public static void isNotNull(Object value, ResultStatus error) throws LogicException {
        LogicAssert.isNotNull(value, error, null);
    }

    public static void isNotNull(Object value, String message) throws LogicException {
        if (value != null) {
            throw LogicException.of(ResultStatus.PARAMETER_INVALID, message);
        }
    }

    public static void isNotNull(Object value, ResultStatus error, String message) throws LogicException {
        if (value != null) {
            throw LogicException.of(error, message);
        }
    }

    public static void isBlank(String value, ResultStatus error) throws LogicException {
        LogicAssert.isBlank(value, error, null);
    }

    public static void isBlank(String value, String message) throws LogicException {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw LogicException.of(ResultStatus.PARAMETER_EMPTY, message);
        }
    }

    public static void isBlank(String value, ResultStatus error, String message) throws LogicException {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw LogicException.of(error, message);
        }
    }

    public static void isNotBlank(String value, ResultStatus error) throws LogicException {
        LogicAssert.isNotBlank(value, error, null);
    }

    public static void isNotBlank(String value, String message) throws LogicException {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            throw LogicException.of(ResultStatus.PARAMETER_INVALID, message);
        }
    }

    public static void isNotBlank(String value, ResultStatus error, String message) throws LogicException {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            throw LogicException.of(error, message);
        }
    }

    public static void isTrue(boolean expression, ResultStatus error) throws LogicException {
        LogicAssert.isTrue(expression, error, null);
    }

    public static void isTrue(boolean expression, String message) throws LogicException {
        if (expression) {
            throw LogicException.of(ResultStatus.PARAMETER_INVALID, message);
        }
    }

    public static void isTrue(boolean expression, ResultStatus error, String message) throws LogicException {
        if (expression) {
            throw LogicException.of(error, message);
        }
    }

    public static void isFalse(boolean expression, ResultStatus error) throws LogicException {
        LogicAssert.isFalse(expression, error, null);
    }

    public static void isFalse(boolean expression, String message) throws LogicException {
        if (!expression) {
            throw LogicException.of(ResultStatus.PARAMETER_INVALID, message);
        }
    }

    public static void isFalse(boolean expression, ResultStatus error, String message) throws LogicException {
        if (!expression) {
            throw LogicException.of(error, message);
        }
    }

    public static void isEmpty(Collection<?> value, ResultStatus error) throws LogicException {
        LogicAssert.isEmpty(value, error, null);
    }

    public static void isEmpty(Collection<?> value, String message) throws LogicException {
        if (value == null || value.isEmpty()) {
            throw LogicException.of(ResultStatus.PARAMETER_EMPTY, message);
        }
    }

    public static void isEmpty(Collection<?> value, ResultStatus error, String message) throws LogicException {
        if (value == null || value.isEmpty()) {
            throw LogicException.of(error, message);
        }
    }

    public static void isEmpty(JSONObject value, ResultStatus error) throws LogicException {
        LogicAssert.isEmpty(value, error, null);
    }

    public static void isEmpty(JSONObject value, ResultStatus error, String message) throws LogicException {
        if (value == null || value.isEmpty()) {
            throw LogicException.of(error, message);
        }
    }

    public static void isEmpty(Map<?, ?> value, ResultStatus error) throws LogicException {
        LogicAssert.isEmpty(value, error, null);
    }

    public static void isEmpty(Map<?, ?> value, ResultStatus error, String message) throws LogicException {
        if (value == null || value.isEmpty()) {
            throw LogicException.of(error, message);
        }
    }

    public static void isNotEmpty(Collection<?> value, ResultStatus error) throws LogicException {
        LogicAssert.isNotEmpty(value, error, null);
    }

    public static void isNotEmpty(Collection<?> value, ResultStatus error, String message) throws LogicException {
        if (value != null && !value.isEmpty()) {
            throw LogicException.of(error, message);
        }
    }

    public static void isNotEmpty(Map<?, ?> value, ResultStatus error) throws LogicException {
        LogicAssert.isNotEmpty(value, error, null);
    }

    public static void isNotEmpty(Map<?, ?> value, ResultStatus error, String message) throws LogicException {
        if (value != null && !value.isEmpty()) {
            throw LogicException.of(error, message);
        }
    }

    public static void isError(Result<?> result, ResultStatus error) throws LogicException {
        LogicAssert.isError(result, error, null);
    }

    public static void isError(Result<?> result, ResultStatus error, String message) throws LogicException {
        if (result == null || result.isFailure()) {
            throw LogicException.of(error, StringUtils.isBlank((CharSequence)message) ? error.getLabel() : message);
        }
    }

    public static void isNotEquals(String value1, String value2, ResultStatus status) throws LogicException {
        LogicAssert.isNotEquals(value1, value2, status, null);
    }

    public static void isNotEquals(String value1, String value2, ResultStatus status, String desc) throws LogicException {
        if (!StringUtils.equals((CharSequence)value1, (CharSequence)value2)) {
            throw LogicException.of(status, desc);
        }
    }
}

