package cn.basic.library.validate;
import org.apache.commons.lang3.StringUtils;

import cn.jslim.basic.utils.MobilePhoneUtil;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

/**
 * 增加手机号码格式验证
 * 
 * @author Administrator
 *
 */
public class MobilePhoneConstraintValidator implements ConstraintValidator<MobilePhone, String> {

	@Override
	public boolean isValid(String value, ConstraintValidatorContext context) {
		if (StringUtils.isBlank(value)) {
			return true;
		}
		return MobilePhoneUtil.isChinaNumber(value);
	}

}