package cn.basic.library.source;

import java.io.IOException;
import java.util.List;

import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

/**
 * 增加属性文件解析器,完成yml格式的文件解析
 * 
 *
 */
public class YamlPropertySourceFactory implements PropertySourceFactory {

	@Override
	public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
		String yamlName = resource.getResource().getFilename();
		Resource yamlResource = resource.getResource();
		List<PropertySource<?>> list = new YamlPropertySourceLoader().load(yamlName, yamlResource);
		CompositePropertySource propertySource = new CompositePropertySource(yamlName);
		list.forEach(ps -> propertySource.addPropertySource(ps));
		return propertySource;
	}

}
