package cn.basic.library.source;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.io.support.PropertySourceFactory;

/**
 * 扩展spring,增加自动加载yml格式文件
 * 
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@PropertySource("")
public @interface YamlPropertySource {

	@AliasFor(annotation = PropertySource.class)
	String name() default "";

	@AliasFor(annotation = PropertySource.class)
	String[] value();

	@AliasFor(annotation = PropertySource.class)
	boolean ignoreResourceNotFound() default false;

	@AliasFor(annotation = PropertySource.class)
	String encoding() default "";

	@AliasFor(annotation = PropertySource.class)
	Class<? extends PropertySourceFactory> factory() default YamlPropertySourceFactory.class;

}
