package cn.basic.library.context;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import cn.jslim.basic.toolkit.Final;
import jakarta.servlet.http.HttpServletRequest;

public class TenantContextHolder {

	public static Long getTenantId() {
		HttpServletRequest request = ServletContextHolder.getRequest();
		if (null == request) {
			return null;
		}
		String tenantIdStr = request.getHeader(Final.HEADER_TENANT);
		if (StringUtils.isBlank(tenantIdStr)) {
			tenantIdStr = (String) request.getAttribute(Final.HEADER_TENANT);
		}
		if (StringUtils.isBlank(tenantIdStr)) {
			return null;
		}
		if (!NumberUtils.isCreatable(tenantIdStr)) {
			return null;
		}
		return Long.parseLong(tenantIdStr);
	}

}