package cn.basic.library.validate;

import cn.jslim.basic.toolkit.domain.Enum;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

/**
 * 枚举范围校验
 * 
 * @author Administrator
 *
 */
public class RangeEnumConstraintValidator implements ConstraintValidator<RangeEnum, Object> {

	private Class<? extends Enum<?, ?>> clazz;

	@Override
	public void initialize(RangeEnum constraintAnnotation) {
		this.clazz = constraintAnnotation.value();
	}

	@Override
	public boolean isValid(Object value, ConstraintValidatorContext context) {
		if (null == value) {
			return false;
		}
		for (Enum<?, ?> be : this.clazz.getEnumConstants()) {
			if (be.getValue().equals(value)) {
				return true;
			}
		}
		return false;
	}

}