package cn.basic.library.context;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import cn.jslim.basic.toolkit.Final;
import jakarta.servlet.http.HttpServletRequest;

public class MemberContextHolder {

	public static Long getMemberId() {
		HttpServletRequest request = ServletContextHolder.getRequest();
		if (null == request) {
			return null;
		}
		String memberIdStr = request.getHeader(Final.HEADER_MEMBER);
		if (StringUtils.isBlank(memberIdStr)) {
			memberIdStr = (String) request.getAttribute(Final.HEADER_MEMBER);
		}
		if (StringUtils.isBlank(memberIdStr)) {
			return null;
		}
		if (!NumberUtils.isCreatable(memberIdStr)) {
			return null;
		}
		return Long.parseLong(memberIdStr);
	}

}