/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.word.core;

import cn.hutool.core.io.resource.ClassPathResource;
import cn.jrack.core.util.common.StringUtil;
import cn.jrack.springboot.word.core.JrackWordBuilder;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JrackWord {
    private static final Logger log = LoggerFactory.getLogger(JrackWord.class);
    protected XWPFTemplate xwpfTemplate;
    protected String filePath;
    protected String templateFilePath;
    protected HashMap<String, Object> renderData = new HashMap();
    protected Configure configure;
    protected Boolean isResource = false;

    public static JrackWordBuilder builder() {
        return new JrackWordBuilder();
    }

    public String getTemplateFilePath() {
        String tempFile = "";
        if (this.isResource.booleanValue()) {
            ClassPathResource classPathResource = new ClassPathResource(this.templateFilePath);
            tempFile = classPathResource.getPath();
        } else {
            tempFile = this.templateFilePath;
        }
        return tempFile;
    }

    public void writeToFile() throws Exception {
        if (StringUtil.isEmpty((String)this.filePath)) {
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.writeToFile(this.filePath);
    }

    public void writeToFile(String filePath) throws Exception {
        File file = new File(this.templateFilePath);
        this.writeToFile(file, filePath);
    }

    public void writeToFile(File templateFile, String filePath) throws Exception {
        if (!templateFile.exists()) {
            throw new Exception("template file not exist");
        }
        XWPFTemplate.compile((File)templateFile, (Configure)this.configure).render(this.renderData).writeToFile(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(HttpServletResponse response, String fileName) throws IOException {
        XWPFTemplate template = null;
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            template = XWPFTemplate.compile((String)this.getTemplateFilePath(), (Configure)this.configure).render(this.renderData);
            template.write((OutputStream)response.getOutputStream());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("{}", (Throwable)ex);
        }
        finally {
            response.getOutputStream().flush();
            if (template != null) {
                try {
                    template.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                response.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(HttpServletResponse response, InputStream is, String fileName) throws IOException {
        XWPFTemplate template = null;
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            template = XWPFTemplate.compile((InputStream)is, (Configure)this.configure).render(this.renderData);
            template.write((OutputStream)response.getOutputStream());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("{}", (Throwable)ex);
        }
        finally {
            response.getOutputStream().flush();
            if (template != null) {
                try {
                    template.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                response.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            JrackWord build = JrackWord.builder().fileName("123").templateFilePath("/Users/zhaoyang/cbd/\u6a21\u7248/template-abc1.docx").putImageUrl("var", 100, 200, "https://t7.baidu.com/it/u=1595072465,3644073269&fm=193&f=GIF").build();
            build.writeToFile("/Users/zhaoyang/cbd/\u6a21\u7248/abc1.docx");
        }
        catch (Exception ex) {
            log.error("{}", (Throwable)ex);
        }
    }
}

