/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.word.core;

import cn.jrack.core.util.common.ReflexObjectUtil;
import cn.jrack.core.util.common.StringUtil;
import cn.jrack.springboot.word.core.JrackWord;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.data.ChartMultiSeriesRenderData;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.Pictures;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.plugin.table.LoopRowTableRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JrackWordBuilder {
    private JrackWord jrackWord = new JrackWord();
    private ConfigureBuilder configureBuilder;
    private Map<String, Object> tempMap = new HashMap<String, Object>();

    public JrackWordBuilder fileName(String fileName) {
        this.jrackWord.filePath = fileName;
        return this;
    }

    public JrackWordBuilder templateFilePath(String templateFilePath) {
        this.jrackWord.templateFilePath = templateFilePath;
        return this;
    }

    public JrackWordBuilder putContent(String tag, Object Value) {
        this.jrackWord.renderData.put(tag, Value);
        return this;
    }

    public JrackWordBuilder putContent(String tag, Object value, Style style) {
        this.jrackWord.renderData.put(tag, new TextRenderData(value.toString(), style));
        return this;
    }

    public JrackWordBuilder putImage(String tag, int width, int height, File file) {
        this.putImage(tag, Pictures.ofLocal((String)file.getPath()).size(width, height).create());
        return this;
    }

    public JrackWordBuilder putImage(String tag, int width, int height, String filePath) {
        this.putImage(tag, width, height, new File(filePath));
        return this;
    }

    public JrackWordBuilder putImageUrl(String tag, int width, int height, String url) {
        this.jrackWord.renderData.put(tag, Pictures.ofUrl((String)url).size(width, height).create());
        return this;
    }

    public JrackWordBuilder putImage(String tag, int width, int height, PictureType format, FileInputStream fileInputStream) throws FileNotFoundException {
        this.putImage(tag, Pictures.ofStream((InputStream)fileInputStream, (PictureType)format).size(width, height).create());
        return this;
    }

    public JrackWordBuilder putImage(String tag, PictureRenderData pictureRenderData) {
        this.jrackWord.renderData.put(tag, pictureRenderData);
        return this;
    }

    public JrackWordBuilder putTable(String tag, List list) {
        LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();
        this.configureBuilder = Configure.builder().bind(tag, (RenderPolicy)policy);
        this.jrackWord.renderData.put(tag, list);
        return this;
    }

    public JrackWordBuilder putPie(String tag, List list, ChartMultiSeriesRenderData chart) {
        this.jrackWord.renderData.put(tag, chart);
        return this;
    }

    public JrackWordBuilder putLine(String tag, List list, LoopRowTableRenderPolicy policy) {
        this.configureBuilder = Configure.builder().bind(tag, (RenderPolicy)policy);
        this.jrackWord.renderData.put(tag, list);
        return this;
    }

    public JrackWordBuilder putBar(String tag, List list, LoopRowTableRenderPolicy policy) {
        this.configureBuilder = Configure.builder().bind(tag, (RenderPolicy)policy);
        this.jrackWord.renderData.put(tag, list);
        return this;
    }

    public JrackWordBuilder data(HashMap<String, Object> renderData) {
        this.tempMap.putAll(renderData);
        return this;
    }

    public JrackWordBuilder data(Object tClass) {
        Map keyAndValue = ReflexObjectUtil.getKeyAndValue((Object)tClass);
        if (keyAndValue.size() > 0) {
            this.tempMap.putAll(keyAndValue);
        }
        return this;
    }

    public JrackWordBuilder data(Map<String, Object> map) {
        this.jrackWord.renderData.putAll(map);
        return this;
    }

    public JrackWord build() {
        if (this.jrackWord.renderData.size() == 0) {
            throw new RuntimeException("renderData is empty");
        }
        if (StringUtil.isEmpty((String)this.jrackWord.templateFilePath)) {
            throw new RuntimeException("templateFilePath is empty");
        }
        this.jrackWord.renderData.putAll(this.tempMap);
        if (this.configureBuilder == null) {
            this.configureBuilder = Configure.builder();
        }
        this.jrackWord.configure = this.configureBuilder.build();
        return this.jrackWord;
    }
}

