/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.word.core;

import cn.jrack.core.util.common.StringUtil;
import cn.jrack.springboot.word.core.JrackWordBuilder;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JrackWord {
    private static final Logger log = LoggerFactory.getLogger(JrackWord.class);
    protected XWPFTemplate xwpfTemplate;
    protected String filePath;
    protected String templateFilePath;
    protected HashMap<String, Object> renderData = new HashMap();
    protected Configure configure;

    public static JrackWordBuilder builder() {
        return new JrackWordBuilder();
    }

    public void writeToFile() throws Exception {
        if (StringUtil.isEmpty((String)this.filePath)) {
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.writeToFile(this.filePath);
    }

    public void writeToFile(String filePath) throws Exception {
        File file = new File(this.templateFilePath);
        if (!file.exists()) {
            throw new Exception("template file not exist");
        }
        XWPFTemplate.compile((File)file, (Configure)this.configure).render(this.renderData).writeToFile(filePath);
    }

    public void download() throws Exception {
        if (StringUtil.isEmpty((String)this.filePath)) {
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.download(this.filePath);
    }

    public void download(String filePath) throws IOException {
        this.xwpfTemplate.writeToFile(filePath);
    }

    public static void main(String[] args) {
        try {
            JrackWord build = JrackWord.builder().fileName("123").templateFilePath("/Users/zhaoyang/cbd/\u6a21\u7248/template-abc1.docx").putImageUrl("var", 100, 200, "https://t7.baidu.com/it/u=1595072465,3644073269&fm=193&f=GIF").build();
            build.writeToFile("/Users/zhaoyang/cbd/\u6a21\u7248/abc1.docx");
        }
        catch (Exception ex) {
            log.error("{}", (Throwable)ex);
        }
    }
}

