package cn.jrack.springboot.word.core;

import cn.jrack.core.util.collection.MapUtil;
import cn.jrack.core.util.common.ReflexObjectUtil;
import cn.jrack.core.util.common.StringUtil;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.data.*;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.plugin.table.LoopRowTableRenderPolicy;
import org.apache.poi.ss.formula.functions.T;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *JrackWordBuilder
 *@author joy
 *@date 2023-12-27
 */
public class JrackWordBuilder {

    private JrackWord jrackWord = new JrackWord();


    private ConfigureBuilder configureBuilder;

    private Map<String, Object> tempMap = new HashMap<>();

    public JrackWordBuilder fileName(String fileName) {

        this.jrackWord.filePath = fileName;
        return this;
    }

    public JrackWordBuilder templateFilePath(String templateFilePath) {
        this.jrackWord.templateFilePath = templateFilePath;
        return this;
    }


    public JrackWordBuilder putContent(String tag, Object Value) {
        this.jrackWord.renderData.put(tag, Value);
        return this;
    }

    //1.删除线
    //2.粗体
    //3.斜体
    //4.颜色
    //5.下划线
    //6.字体
    //7.字号
    //8.背景高亮色
    public JrackWordBuilder putContent(String tag, Object value, Style style) {
        this.jrackWord.renderData.put(tag, new TextRenderData(value.toString(), style));
        return this;
    }

    public JrackWordBuilder putImage(String tag, int width, int height, File file) {
        this.putImage(tag, Pictures.ofLocal(file.getPath()).size(width, height).create());
        return this;
    }

    public JrackWordBuilder putImage(String tag, int width, int height, String filePath) {

        this.putImage(tag, width, height, new File(filePath));
        return this;
    }

    public JrackWordBuilder putImageUrl(String tag, int width, int height, String url) {

        this.jrackWord.renderData.put(tag, Pictures.ofUrl(url).size(width, height).create());
        return this;
    }

    public JrackWordBuilder putImage(String tag, int width, int height, PictureType format, FileInputStream fileInputStream) throws FileNotFoundException {

        this.putImage(tag, Pictures.ofStream(fileInputStream, format).size(width, height).create());
        return this;
    }
//
//    public JrackWordBuilder putImage(String tag, int width, int height, PictureType format, BufferedImage image) throws FileNotFoundException {
//        PictureRenderData pictureRenderData = new PictureRenderData(width, height, format, image);
//        this.putImage(tag, pictureRenderData);
//        return this;
//    }

    public JrackWordBuilder putImage(String tag, PictureRenderData pictureRenderData) {
        this.jrackWord.renderData.put(tag, pictureRenderData);
        return this;
    }


    public JrackWordBuilder putTable(String tag, List list) {
        LoopRowTableRenderPolicy policy = new LoopRowTableRenderPolicy();

        configureBuilder = Configure.builder().bind(tag, policy);
        this.jrackWord.renderData.put(tag, list);
        return this;
    }

    //多系列图表指的是条形图（3D条形图）、柱形图（3D柱形图）、面积图（3D面积图）、折线图（3D折线图）、雷达图、散点图等。
    public JrackWordBuilder putPie(String tag, List list, ChartMultiSeriesRenderData chart) {

//        ChartMultiSeriesRenderData chart = Charts
//                .ofMultiSeries("ChartTitle", new String[] { "中文", "English" })
//                .addSeries("countries", new Double[] { 15.0, 6.0 })
//                .addSeries("speakers", new Double[] { 223.0, 119.0 })
//                .create();

        this.jrackWord.renderData.put(tag, chart);
        return this;
    }

    public JrackWordBuilder putLine(String tag, List list, LoopRowTableRenderPolicy policy) {
        configureBuilder = Configure.builder().bind(tag, policy);
        this.jrackWord.renderData.put(tag, list);
        return this;
    }

    public JrackWordBuilder putBar(String tag, List list, LoopRowTableRenderPolicy policy) {
        configureBuilder = Configure.builder().bind(tag, policy);
        this.jrackWord.renderData.put(tag, list);
        return this;
    }


    public JrackWordBuilder data(HashMap<String, Object> renderData) {
        tempMap.putAll(renderData);
        return this;
    }

    public JrackWordBuilder data(Object tClass) {

        Map<String, Object> keyAndValue = ReflexObjectUtil.getKeyAndValue(tClass);
        if (keyAndValue.size() > 0) {
            tempMap.putAll(keyAndValue);
        }
        return this;
    }

    public JrackWordBuilder data(Map<String, Object> map) {

        this.jrackWord.renderData.putAll(map);
        return this;
    }

    public JrackWord build() {
        if (this.jrackWord.renderData.size() == 0) {
            throw new RuntimeException("renderData is empty");
        }
        if (StringUtil.isEmpty(this.jrackWord.templateFilePath)) {
            throw new RuntimeException("templateFilePath is empty");
        }
        this.jrackWord.renderData.putAll(tempMap);
        if (configureBuilder == null) {
            configureBuilder = Configure.builder();
        }
        jrackWord.configure = configureBuilder.build();
        return jrackWord;
    }

}
