/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.word.core;

import cn.jrack.core.util.common.StringUtil;
import cn.jrack.springboot.word.core.JrackWordBuilder;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JrackWord {
    private static final Logger log = LoggerFactory.getLogger(JrackWord.class);
    protected XWPFTemplate xwpfTemplate;
    protected String filePath;
    protected String templateFilePath;
    protected HashMap<String, Object> renderData = new HashMap();
    protected Configure configure;

    public static JrackWordBuilder builder() {
        return new JrackWordBuilder();
    }

    public void writeToFile() throws Exception {
        if (StringUtil.isEmpty((String)this.filePath)) {
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.writeToFile(this.filePath);
    }

    public void writeToFile(String filePath) throws Exception {
        File file = new File(this.templateFilePath);
        if (!file.exists()) {
            throw new Exception("template file not exist");
        }
        XWPFTemplate.compile((File)file, (Configure)this.configure).render(this.renderData).writeToFile(filePath);
    }

    public void download() throws Exception {
        if (StringUtil.isEmpty((String)this.filePath)) {
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.download(this.filePath);
    }

    public void download(String filePath) throws IOException {
        this.xwpfTemplate.writeToFile(filePath);
    }

    public static List<Ent> buildData() {
        ArrayList<Ent> list = new ArrayList<Ent>();
        for (int i = 0; i < 10; ++i) {
            Ent ent = new JrackWord().new Ent();
            ent.setOrgName("orgName" + i);
            ent.setPrice(50000 + i);
            ent.setDate("2020-12-12");
            list.add(ent);
        }
        return list;
    }

    public static void main(String[] args) {
        try {
            Ent ent = new JrackWord().new Ent();
            JrackWord build = JrackWord.builder().fileName("123").templateFilePath("/Users/zhaoyang/cbd/\u6a21\u7248/template-abc1.docx").putImageUrl("var", 100, 200, "https://t7.baidu.com/it/u=1595072465,3644073269&fm=193&f=GIF").data(ent).build();
            build.writeToFile("/Users/zhaoyang/cbd/\u6a21\u7248/abc1.docx");
        }
        catch (Exception ex) {
            log.error("{}", (Throwable)ex);
        }
    }

    public class Ent {
        private String orgName;
        private int price;
        private String date;

        public String getOrgName() {
            return this.orgName;
        }

        public int getPrice() {
            return this.price;
        }

        public String getDate() {
            return this.date;
        }

        public void setOrgName(String orgName) {
            this.orgName = orgName;
        }

        public void setPrice(int price) {
            this.price = price;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ent)) {
                return false;
            }
            Ent other = (Ent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPrice() != other.getPrice()) {
                return false;
            }
            String this$orgName = this.getOrgName();
            String other$orgName = other.getOrgName();
            if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            return !(this$date == null ? other$date != null : !this$date.equals(other$date));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPrice();
            String $orgName = this.getOrgName();
            result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            return result;
        }

        public String toString() {
            return "JrackWord.Ent(orgName=" + this.getOrgName() + ", price=" + this.getPrice() + ", date=" + this.getDate() + ")";
        }
    }
}

