package cn.jrack.springboot.word.core;

import cn.jrack.core.util.common.StringUtil;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.Style;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.awt.image.BufferedImage;
import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 *JrackWord
 *@author joy
 *@date 2023-12-27
 */
@Slf4j
public class JrackWord {

    protected XWPFTemplate xwpfTemplate;

    protected String filePath;

    protected String templateFilePath;

    protected HashMap<String, Object> renderData = new HashMap<>();

    protected Configure configure;


    public JrackWord() {
    }

    public static JrackWordBuilder builder() {
        return new JrackWordBuilder();
    }


    public void writeToFile() throws Exception {
        if (StringUtil.isEmpty(filePath)) {
            throw new Exception("文件路径不能为空");
        }
        writeToFile(filePath);
    }

    public void writeToFile(String filePath) throws Exception {
        File file = new File(templateFilePath);
        if (!file.exists()) {
            throw new Exception("template file not exist");
        }
        XWPFTemplate.compile(file, configure)
                .render(renderData).writeToFile(filePath);

    }

    public void download() throws Exception {
        if (StringUtil.isEmpty(filePath)) {
            throw new Exception("文件路径不能为空");
        }
        download(filePath);
    }

    public void download(String filePath) throws IOException {
        xwpfTemplate.writeToFile(filePath);
    }

    @Data
    public class Ent {
        private String orgName;
        private int price;
        private String date;
    }

    public static List<Ent> buildData() {
        List<Ent> list = new ArrayList<>();

        for (int i = 0; i < 10; i++) {
            Ent ent = new JrackWord().new Ent();
            ent.setOrgName("orgName" + i);
            ent.setPrice(50000 + i);
            ent.setDate("2020-12-12");
            list.add(ent);
        }
        return list;
    }

    public static void main(String[] args) {
        try {
            Ent ent = new JrackWord().new Ent();
            JrackWord build = JrackWord.builder()
                    .fileName("123")
                    .templateFilePath("/Users/zhaoyang/cbd/模版/template-abc1.docx")
                    .putImageUrl("var", 100, 200, "https://t7.baidu.com/it/u=1595072465,3644073269&fm=193&f=GIF")
                    .data(ent)
                    .build();

            build.writeToFile("/Users/zhaoyang/cbd/模版/abc1.docx");

        } catch (Exception ex) {
            log.error("{}", ex);
        }

    }
}
