/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.websocket.core.handler;

import cn.jrack.springboot.websocket.core.handler.SocketClient;
import cn.jrack.springboot.websocket.core.handler.Websocket;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SocketManager
implements Websocket.Manager<SocketClient> {
    private static CopyOnWriteArraySet<SocketClient> linkSet = new CopyOnWriteArraySet();
    private static SocketManager instance = new SocketManager();

    private SocketManager() {
    }

    public static SocketManager getInstance() {
        return instance;
    }

    public void sendText(String text, SocketClient ... clients) {
        for (SocketClient client : clients) {
            client.sendText(text);
        }
    }

    @Override
    public void sendTextToAll(String text) {
        for (SocketClient socketClient : linkSet) {
            socketClient.sendText(text);
        }
    }

    public void send(Object object, SocketClient ... clients) {
        for (SocketClient client : clients) {
            client.send(object);
        }
    }

    @Override
    public void sendToAll(Object object) {
        for (SocketClient socketClient : linkSet) {
            socketClient.send(object);
        }
    }

    public void sendTextToOther(String text, SocketClient ... clients) {
        Set tagSet = Arrays.stream(clients).map(SocketClient::getTag).collect(Collectors.toSet());
        for (SocketClient socketClient : linkSet) {
            if (tagSet.contains(socketClient.getTag())) continue;
            socketClient.sendText(text);
        }
    }

    public void sendToOther(Object object, SocketClient ... clients) {
        Set tagSet = Arrays.stream(clients).map(SocketClient::getTag).collect(Collectors.toSet());
        for (SocketClient SocketClient2 : linkSet) {
            if (tagSet.contains(SocketClient2.getTag())) continue;
            SocketClient2.send(object);
        }
    }

    public void addClients(SocketClient ... clients) {
        linkSet.addAll(Arrays.asList(clients));
    }

    @Override
    public CopyOnWriteArraySet<SocketClient> all() {
        return linkSet;
    }

    public void removeClients(SocketClient ... clients) {
        for (SocketClient client : clients) {
            linkSet.remove(client);
        }
    }

    @Override
    public SocketClient getClientByTag(String tag) {
        for (SocketClient SocketClient2 : linkSet) {
            if (!SocketClient2.getTag().equals(tag)) continue;
            return SocketClient2;
        }
        return null;
    }

    public SocketClient[] getClientsByTags(String ... tags) {
        if (null == tags || tags.length == 0) {
            return null;
        }
        Set tagSet = Arrays.stream(tags).collect(Collectors.toSet());
        List<SocketClient> clientList = linkSet.stream().filter(c -> tagSet.contains(c.getTag())).collect(Collectors.toList());
        SocketClient[] clients = new SocketClient[clientList.size()];
        clientList.toArray(clients);
        return clients;
    }
}

