package cn.jrack.springboot.websocket.core.handler;

import org.springframework.stereotype.Component;

import javax.websocket.server.ServerEndpoint;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;

@Component

public class SocketManager implements Websocket.Manager<SocketClient> {
    private static CopyOnWriteArraySet<SocketClient> linkSet = new CopyOnWriteArraySet<>();

    //单例
    private static SocketManager instance = new SocketManager();

    private SocketManager() {
    }

    public static SocketManager getInstance() {
        return instance;
    }

    @Override
    public void sendText(String text, SocketClient... clients) {
        for (SocketClient client : clients) {
            client.sendText(text);
        }
    }

    @Override
    public void sendTextToAll(String text) {
        for (SocketClient socketClient : linkSet) {
            socketClient.sendText(text);
        }
    }

    @Override
    public void send(Object object, SocketClient... clients) {
        for (SocketClient client : clients) {
            client.send(object);
        }
    }

    @Override
    public void sendToAll(Object object) {
        for (SocketClient socketClient : linkSet) {
            socketClient.send(object);
        }
    }

    @Override
    public void sendTextToOther(String text, SocketClient... clients) {
        Set<String> tagSet = Arrays.stream(clients).map(SocketClient::getTag).collect(Collectors.toSet());
        for (SocketClient socketClient : linkSet) {
            if (tagSet.contains(socketClient.getTag())) {
                continue;
            }
            socketClient.sendText(text);
        }
    }

    @Override
    public void sendToOther(Object object, SocketClient... clients) {
        Set<String> tagSet = Arrays.stream(clients).map(SocketClient::getTag).collect(Collectors.toSet());
        for (SocketClient SocketClient : linkSet) {
            if (tagSet.contains(SocketClient.getTag())) {
                continue;
            }
            SocketClient.send(object);
        }
    }

    @Override
    public void addClients(SocketClient... clients) {
        linkSet.addAll(Arrays.asList(clients));
    }

    @Override
    public CopyOnWriteArraySet<SocketClient> all() {
        return linkSet;
    }

    @Override
    public void removeClients(SocketClient... clients) {
        for (SocketClient client : clients) {
            linkSet.remove(client);
        }
    }

    @Override
    public SocketClient getClientByTag(String tag) {
        for (SocketClient SocketClient : linkSet) {
            if (SocketClient.getTag().equals(tag)) {
                return SocketClient;
            }
        }
        return null;
    }

    @Override
    public SocketClient[] getClientsByTags(String... tags) {
        if (null == tags || tags.length == 0) {
            return null;
        }
        Set<String> tagSet = Arrays.stream(tags).collect(Collectors.toSet());
        List<SocketClient> clientList = linkSet.stream().filter(c -> tagSet.contains(c.getTag())).collect(Collectors.toList());
        SocketClient[] clients = new SocketClient[clientList.size()];
        clientList.toArray(clients);
        return clients;
    }


}
