package cn.jrack.springboot.websocket.core.handler;

import cn.jrack.springboot.websocket.core.pojo.WebsocketMessage;
import cn.jrack.springboot.websocket.core.pojo.WebsocketMessageType;
import cn.jrack.springboot.websocket.core.pojo.WebsocketUser;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.websocket.*;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;

@Component
@ServerEndpoint("/chat/{token}")
public class SocketClient implements Websocket.LinkPoint, Websocket.Client {

    private static SocketManager socketManager = SocketManager.getInstance();
    private String tag;
    private Session session;

    @OnOpen
    @Override
    public void onOpen(Session session, @PathParam("token") String token) {
        this.session = session;
        this.tag = token;

        socketManager.addClients(this);
        String msg = token + " 上线了" + "目前在线 " + socketManager.all().size() + " 人";
        System.out.println(msg);


        String message = sendMsg(token, "ALL", WebsocketMessageType.NOTICE, token + "上线了");
        socketManager.sendTextToOther(message, this);
    }

    @OnMessage
    @Override
    public void onMessage(String message) {
        System.out.println(message);
        socketManager.sendTextToOther(message, this);
    }

    @OnClose
    @Override
    public void onClose() {
        socketManager.removeClients(this);
        String msg = tag + " 下线了,目前在线 " + socketManager.all().size() + " 人";
        System.out.println(msg);
        String message = sendMsg(tag, "ALL", WebsocketMessageType.NOTICE, tag + "下线了");
        socketManager.sendTextToOther(message);
    }

    @OnError
    @Override
    public void onError(Session session, Throwable throwable) {
        System.out.println("出错");
        try {
            session.close();
            socketManager.removeClients(this);
            String msg = tag + " 离线了,目前在线 " + socketManager.all().size() + " 人";
            System.out.println(msg);
            String message = sendMsg(tag, "ALL", WebsocketMessageType.NOTICE, tag + " 离线了,目前在线 " + socketManager.all().size() + " 人");
            socketManager.sendTextToOther(message);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }
    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void sendText(String text) {
        try {
            session.getBasicRemote().sendText(text);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(Object object) {
        try {
            session.getBasicRemote().sendObject(object);
        } catch (IOException | EncodeException e) {
            e.printStackTrace();
        }
    }
    public String sendMsg(String token, String receiveId, String type, String msg) {
        WebsocketMessage websocketMessage = new WebsocketMessage();
        websocketMessage.setText(msg);
        websocketMessage.setToken(token);
        websocketMessage.setSendId(token);
        websocketMessage.setReceiveId(receiveId);
        websocketMessage.setType(type);
        return websocketMessage.toString();
    }
}
