/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.websocket.core.handler;

import cn.jrack.springboot.websocket.core.handler.SocketManager;
import cn.jrack.springboot.websocket.core.handler.Websocket;
import cn.jrack.springboot.websocket.core.pojo.WebsocketMessage;
import java.io.IOException;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/chat/{token}")
public class SocketClient
implements Websocket.LinkPoint,
Websocket.Client {
    private static SocketManager socketManager = SocketManager.getInstance();
    private String tag;
    private Session session;

    @Override
    @OnOpen
    public void onOpen(Session session, @PathParam(value="token") String token) {
        this.session = session;
        this.tag = token;
        socketManager.addClients(this);
        String msg = token + " \u4e0a\u7ebf\u4e86\u76ee\u524d\u5728\u7ebf " + socketManager.all().size() + " \u4eba";
        System.out.println(msg);
        String message = this.sendMsg(token, "ALL", "notice", token + "\u4e0a\u7ebf\u4e86");
        socketManager.sendTextToOther(message, this);
    }

    @Override
    @OnMessage
    public void onMessage(String message) {
        System.out.println(message);
        socketManager.sendTextToOther(message, this);
    }

    @Override
    @OnClose
    public void onClose() {
        socketManager.removeClients(this);
        String msg = this.tag + " \u4e0b\u7ebf\u4e86,\u76ee\u524d\u5728\u7ebf " + socketManager.all().size() + " \u4eba";
        System.out.println(msg);
        String message = this.sendMsg(this.tag, "ALL", "notice", this.tag + "\u4e0b\u7ebf\u4e86");
        socketManager.sendTextToOther(message, new SocketClient[0]);
    }

    @Override
    @OnError
    public void onError(Session session, Throwable throwable) {
        System.out.println("\u51fa\u9519");
        try {
            session.close();
            socketManager.removeClients(this);
            String msg = this.tag + " \u79bb\u7ebf\u4e86,\u76ee\u524d\u5728\u7ebf " + socketManager.all().size() + " \u4eba";
            System.out.println(msg);
            String message = this.sendMsg(this.tag, "ALL", "notice", this.tag + " \u79bb\u7ebf\u4e86,\u76ee\u524d\u5728\u7ebf " + socketManager.all().size() + " \u4eba");
            socketManager.sendTextToOther(message, new SocketClient[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void sendText(String text) {
        try {
            this.session.getBasicRemote().sendText(text);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(Object object) {
        try {
            this.session.getBasicRemote().sendObject(object);
        }
        catch (IOException | EncodeException e) {
            e.printStackTrace();
        }
    }

    public String sendMsg(String token, String receiveId, String type, String msg) {
        WebsocketMessage websocketMessage = new WebsocketMessage();
        websocketMessage.setText(msg);
        websocketMessage.setToken(token);
        websocketMessage.setSendId(token);
        websocketMessage.setReceiveId(receiveId);
        websocketMessage.setType(type);
        return websocketMessage.toString();
    }
}

