package cn.jrack.web.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
 
import java.io.IOException;
import java.util.Objects;

@Order(999)
public class DicSerializer extends JsonSerializer<Object> implements ContextualSerializer {
 
    private String code;
    private String fieldName;
 
 
    public DicSerializer(String code, String fieldName) {
        this.code = code;
        this.fieldName = fieldName;
    }


    @Override
    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObject(o);
        jsonGenerator.writeFieldName(fieldName);
        //这一步是通过code和value获取name，根据自己框架获取哈，我这里
        // 只是模拟一个获取的方法
        String name = DicData.getNameByCodeAndValue(this.code,o);
        jsonGenerator.writeString(name);
    }

 
    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if(beanProperty !=null){
            if(Objects.equals (beanProperty.getType ().getRawClass (), String.class)){
                Dict t =beanProperty.getAnnotation (Dict.class);
                if(t !=null){
                    String beanFieldName = beanProperty.getName();
                    if(StringUtils.hasText(t.fieldName())){
                        beanFieldName = t.fieldName();
                    }
                    return new DicSerializer(t.code(),beanFieldName+"Text");
                }
            }
            return serializerProvider.findValueSerializer (beanProperty.getType (), beanProperty);
        }
        return serializerProvider.findNullValueSerializer (beanProperty);
    }
}