/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.web.config;

import cn.jrack.web.config.DicData;
import cn.jrack.web.config.Dict;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=999)
public class DicSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    private String code;
    private String fieldName;

    public DicSerializer(String code, String fieldName) {
        this.code = code;
        this.fieldName = fieldName;
    }

    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObject(o);
        jsonGenerator.writeFieldName(this.fieldName);
        String name = DicData.getNameByCodeAndValue(this.code, o);
        jsonGenerator.writeString(name);
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            Dict t;
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class) && (t = (Dict)beanProperty.getAnnotation(Dict.class)) != null) {
                String beanFieldName = beanProperty.getName();
                if (StringUtils.hasText((String)t.fieldName())) {
                    beanFieldName = t.fieldName();
                }
                return new DicSerializer(t.code(), beanFieldName + "Text");
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(beanProperty);
    }
}

