package cn.jrack.springboot.web.core.util;


import cn.jrack.core.constant.SystemConstant;
import cn.jrack.springboot.satoken.core.StUserInfo;
import cn.jrack.springboot.satoken.core.util.SaTokenUtils;


import cn.jrack.springboot.web.core.response.Result;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/**
 * 专属于 web 包的工具类
 *
 * @author ZhaoYang
 */
public class WebFrameworkUtils {

    private static final String REQUEST_ATTRIBUTE_LOGIN_USER_TYPE = SystemConstant.NAME + "_login_user_type";

    private static final String REQUEST_ATTRIBUTE_COMMON_RESULT = SystemConstant.NAME + "_result";


    private static WebProperties properties;

    public WebFrameworkUtils(WebProperties webProperties) {
        WebFrameworkUtils.properties = webProperties;
    }


    /**
     * 设置用户类型
     *
     * @param request  请求
     * @param userType 用户类型
     */
    public static void setLoginUserType(ServletRequest request, Integer userType) {
        request.setAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_TYPE, userType);
    }

    /**
     * 获得当前用户的编号，从缓存中取出
     * 注意：该方法仅限于 framework 框架使用！！！
     *
     * @return 用户登录Id
     */
    public static Object getLoginUserId() {
        return SaTokenUtils.getLoginId();
    }

    /**
     * 判断当前登录信息
     * 注意：该方法仅限于 framework 框架使用！！！
     *
     * @return 用户登录Id
     */
    public static Boolean isLogin() {
        return SaTokenUtils.isLogin();
    }

    public static void login(Object loginId, StUserInfo userInfo) {
        SaTokenUtils.login(loginId, userInfo);
    }

    public static void login(Object loginId, StUserInfo userInfo, Boolean isCreate) {
        SaTokenUtils.login(loginId, userInfo, isCreate);
    }

    public static StUserInfo getLoginUserInfo() {
        return SaTokenUtils.getLoginUserInfo();
    }


    public static void setCommonResult(ServletRequest request, Result<?> result) {
        request.setAttribute(REQUEST_ATTRIBUTE_COMMON_RESULT, result);
    }

    public static Result<?> getCommonResult(ServletRequest request) {
        return (Result<?>) request.getAttribute(REQUEST_ATTRIBUTE_COMMON_RESULT);
    }

    private static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return null;
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
        return servletRequestAttributes.getRequest();
    }

}
