package cn.jrack.springboot.web.config;

import cn.jrack.core.pojo.PageResult;
import cn.jrack.core.util.json.JsonUtil;

import cn.jrack.springboot.web.core.response.Result;
import cn.jrack.springboot.web.core.response.module.ResultTable;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class RestControllerResponseAdvice implements ResponseBodyAdvice<Object> {

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        //response是ResultVo类型
        return !returnType.getParameterType().isAssignableFrom(Result.class);

    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {


        if (returnType.getParameterType().isAssignableFrom(PageResult.class)) {
            return ResultTable.success((PageResult) body);
        }

        //String类型不能直接包装
        if (returnType.getGenericParameterType().equals(String.class)) {
            try {
                return JsonUtil.toJsonString(Result.success(body));
            } catch (Exception e) {
                e.printStackTrace();
                return JsonUtil.toJsonString(Result.failure());
            }
        }
        //否则直接包装成Result返回
        return body;
    }
}
