package cn.jrack.springboot.web.core.service;

import cn.dev33.satoken.stp.StpInterface;
import cn.jrack.springboot.satoken.core.StUserInfo;
import cn.jrack.springboot.web.core.util.WebLoginUserUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * sa-token 权限管理实现类
 *
 * @author Lion Li
 */
public class SaPermissionImpl implements StpInterface {

    /**
     * 获取菜单权限列表
     */
    @Override
    public List<String> getPermissionList(Object loginId, String loginType) {
        StUserInfo loginUserInfo = WebLoginUserUtils.getLoginUserInfo();
        return new ArrayList<>(loginUserInfo.getMenuPermission());
    }

    /**
     * 获取角色权限列表
     */
    @Override
    public List<String> getRoleList(Object loginId, String loginType) {
        return new ArrayList<>();
    }
}
