/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.web.core.filter;

import cn.jrack.springboot.web.config.JrackXssProperties;
import cn.jrack.springboot.web.core.filter.XssRequestWrapper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class XssFilter
extends OncePerRequestFilter {
    private final JrackXssProperties properties;
    private final PathMatcher pathMatcher;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)new XssRequestWrapper(request), (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        if (!this.properties.isEnable()) {
            return true;
        }
        String uri = request.getRequestURI();
        return this.properties.getExcludeUrls().stream().anyMatch(excludeUrl -> this.pathMatcher.match(excludeUrl, uri));
    }

    public XssFilter(JrackXssProperties properties, PathMatcher pathMatcher) {
        this.properties = properties;
        this.pathMatcher = pathMatcher;
    }
}

