/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.web.core.response;

import cn.jrack.core.exception.ErrorCode;
import cn.jrack.springboot.web.core.response.ResultCode;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class Result<T>
extends LinkedHashMap<String, Object>
implements Serializable {
    private boolean success;
    private int code;
    private String msg;
    private T data;

    public Result() {
    }

    public Result(int code, String msg, Object data, Boolean success) {
        this.setCode(code);
        this.setMsg(msg);
        this.setData(data);
        this.setSuccess(success);
    }

    public static <T> Result<T> success() {
        return Result.success(null);
    }

    public static <T> Result<T> success(T data) {
        return Result.success(ResultCode.SUCCESS.getMessage(), data);
    }

    public static <T> Result<T> success(String message) {
        return Result.success(message, null);
    }

    public static <T> Result<T> success(String message, T data) {
        return Result.success(ResultCode.SUCCESS.getCode(), message, data);
    }

    public static <T> Result<T> success(int code, String message) {
        return Result.success(code, message, null);
    }

    public static <T> Result<T> success(int code, String message, T data) {
        return new Result<T>(code, message, data, true);
    }

    public static <T> Result<T> failure() {
        return Result.failure(ResultCode.SUCCESS.getMessage());
    }

    public static <T> Result<T> failure(String message) {
        return Result.failure(message, null);
    }

    public static <T> Result<T> failure(ErrorCode errorCode) {
        return Result.failure(errorCode.getCode(), errorCode.getMsg());
    }

    public static <T> Result<T> failure(String message, T data) {
        return Result.failure(ResultCode.FAILURE.getCode(), message, data);
    }

    public static <T> Result<T> failure(int code, String message) {
        return Result.failure(code, message, null);
    }

    public static <T> Result<T> failure(int code, String message, T data) {
        return new Result<T>(code, message, data, false);
    }

    public static <T> Result<T> decide(boolean b) {
        return Result.decide(b, ResultCode.SUCCESS.getMessage(), ResultCode.FAILURE.getMessage());
    }

    public static <T> Result<T> decide(boolean b, String success, String failure) {
        if (b) {
            return Result.success(success);
        }
        return Result.failure(failure);
    }

    public Result set(String key, Object data) {
        this.put(key, data);
        return this;
    }

    public Result setMap(Map<String, ?> map) {
        for (String key : map.keySet()) {
            this.put(key, map.get(key));
        }
        return this;
    }

    public Result setMsg(String msg) {
        this.put("msg", msg);
        return this;
    }

    public Result setData(Object data) {
        this.put("data", data);
        return this;
    }

    public Result setCode(int code) {
        this.put("code", code);
        return this;
    }

    public Result setSuccess(Boolean success) {
        this.put("success", success);
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Result(success=" + this.isSuccess() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

