/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.web.config;

import cn.dev33.satoken.interceptor.SaInterceptor;
import cn.jrack.springboot.satoken.core.router.IgnoreSaRouter;
import cn.jrack.springboot.web.config.JrackWebProperties;
import cn.jrack.springboot.web.config.JrackXssProperties;
import cn.jrack.springboot.web.config.RestControllerResponseAdvice;
import cn.jrack.springboot.web.core.filter.CacheRequestBodyFilter;
import cn.jrack.springboot.web.core.filter.XssFilter;
import cn.jrack.springboot.web.core.handler.GlobalExceptionHandler;
import cn.jrack.springboot.web.core.handler.GlobalResponseBodyHandler;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={JrackWebProperties.class, JrackXssProperties.class})
public class JrackWebAutoConfiguration
implements WebMvcConfigurer {
    @Resource
    private JrackWebProperties webProperties;
    @Resource
    private JrackXssProperties xssProperties;
    @Value(value="${spring.application.name}")
    private String applicationName;

    public void configurePathMatch(PathMatchConfigurer configurer) {
        this.configurePathMatch(configurer, this.webProperties.getAdminApi());
        this.configurePathMatch(configurer, this.webProperties.getAppApi());
    }

    @Bean
    public RestControllerResponseAdvice restControllerResponseAdvice() {
        return new RestControllerResponseAdvice();
    }

    private void configurePathMatch(PathMatchConfigurer configurer, JrackWebProperties.Api api) {
        AntPathMatcher antPathMatcher = new AntPathMatcher(".");
        configurer.addPathPrefix(api.getPrefix(), clazz -> clazz.isAnnotationPresent(RestController.class) && antPathMatcher.match(api.getController(), clazz.getPackage().getName()));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.webProperties.getEnableLogin().booleanValue()) {
            registry.addInterceptor((HandlerInterceptor)new SaInterceptor(handle -> new IgnoreSaRouter(handle).run())).addPathPatterns(new String[]{"/**"}).excludePathPatterns(this.xssProperties.getExcludeUrls());
        }
    }

    @Bean
    public GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    @Bean
    public GlobalResponseBodyHandler globalResponseBodyHandler() {
        return new GlobalResponseBodyHandler();
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilterBean() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOriginPattern("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return JrackWebAutoConfiguration.createFilterBean(new CorsFilter((CorsConfigurationSource)source), Integer.MIN_VALUE);
    }

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilter(JrackXssProperties properties, PathMatcher pathMatcher) {
        return JrackWebAutoConfiguration.createFilterBean(new XssFilter(properties, pathMatcher), -102);
    }

    @Bean
    public FilterRegistrationBean<CacheRequestBodyFilter> requestBodyCacheFilter() {
        return JrackWebAutoConfiguration.createFilterBean(new CacheRequestBodyFilter(), -2147483148);
    }

    private static <T extends Filter> FilterRegistrationBean<T> createFilterBean(T filter, Integer order) {
        FilterRegistrationBean bean = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
        bean.setOrder(order.intValue());
        return bean;
    }
}

