package cn.jrack.springboot.jackson.core.databind;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.jrack.core.util.common.StringUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.springframework.boot.jackson.JsonComponent;

import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * LocalDateTime反序列化规则
 * 会将毫秒级时间戳反序列化为LocalDateTime
 */
@JsonComponent
public class LocalDateTimeDeserializer extends JsonDeserializer<LocalDateTime> {

    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();

    private static final String defaultPattern = "yyyy-MM-dd HH:mm:ss";

    @Override
    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {

        String text = jsonParser.getText();
        if (StringUtil.isEmpty(text)) {
            return null;
        }
        //时间戳格式
        if (text.length() == 13 || text.length() == 10) {
            return LocalDateTime.parse(text);
        }
        //yyyy-MM-dd'T'HH:mm:ss.SSSZ
        if (text.contains("T") && text.contains("SSSZ")) {
            return LocalDateTime.parse(text, DateTimeFormatter.ofPattern(defaultPattern));
        }
        if(text.contains("T") && text.contains("Z"))
        {
            DateTime dateTime = DateUtil.parse(text);

            LocalDateTime parse = LocalDateTime.parse( text.replace("Z",""));
            return parse;
        }

        LocalDateTime parse = LocalDateTime.parse(text, DateTimeFormatter.ofPattern(defaultPattern));
        return parse;
    }

    public static void main(String[] args) {


        DateTime dateTime = DateUtil.parse("2023-05-31T16:00:00.000Z");
        System.out.println(LocalDateTime.now().toString());
        LocalDateTime parse = LocalDateTime.parse("2023-05-31T16:00:00.000Z");
        System.out.println(parse);
    }
}
