/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.web.core.util;

import cn.jrack.core.constant.SystemConstant;
import cn.jrack.core.util.web.response.Result;
import cn.jrack.springboot.satoken.core.StUserInfo;
import cn.jrack.springboot.satoken.core.util.SaTokenUtils;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebFrameworkUtils {
    private static final String REQUEST_ATTRIBUTE_LOGIN_USER_TYPE = SystemConstant.NAME + "_login_user_type";
    private static final String REQUEST_ATTRIBUTE_COMMON_RESULT = SystemConstant.NAME + "_result";
    private static WebProperties properties;

    public WebFrameworkUtils(WebProperties webProperties) {
        properties = webProperties;
    }

    public static void setLoginUserType(ServletRequest request, Integer userType) {
        request.setAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_TYPE, (Object)userType);
    }

    public static Object getLoginUserId() {
        return SaTokenUtils.getLoginId();
    }

    public static Boolean isLogin() {
        return SaTokenUtils.isLogin();
    }

    public static void login(Object loginId, StUserInfo userInfo) {
        SaTokenUtils.login((Object)loginId, (StUserInfo)userInfo);
    }

    public static StUserInfo getLoginUserInfo() {
        return SaTokenUtils.getLoginUserInfo();
    }

    public static void setCommonResult(ServletRequest request, Result<?> result) {
        request.setAttribute(REQUEST_ATTRIBUTE_COMMON_RESULT, result);
    }

    public static Result<?> getCommonResult(ServletRequest request) {
        return (Result)request.getAttribute(REQUEST_ATTRIBUTE_COMMON_RESULT);
    }

    private static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return null;
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        return servletRequestAttributes.getRequest();
    }
}

