package cn.jrack.springboot.web.core.filter;


import cn.hutool.core.util.StrUtil;
import cn.jrack.core.util.servlet.ServletUtil;
import cn.jrack.core.util.web.response.Result;
import cn.jrack.springboot.web.core.util.WebFrameworkUtils;

import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static cn.jrack.core.exception.enums.GlobalErrorCodeConstants.DEMO_DENY;


/**
 * 测试及演示使用 Filter，禁止用户发起写操作，避免影响测试数据
 *
 * @author ZhaoYang
 */
public class DemoFilter extends OncePerRequestFilter {

    @Override
    protected boolean shouldNotFilter(HttpServletRequest request) {
        String method = request.getMethod();
        return !StrUtil.equalsAnyIgnoreCase(method, "POST", "PUT", "DELETE")  // 写操作时，不进行过滤率
                || !WebFrameworkUtils.isLogin(); // 非登录用户时，不进行过滤
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        // 直接返回 DEMO_DENY 的结果。即，请求不继续
        ServletUtil.writeJson(response, Result.failure(DEMO_DENY));
    }

}
