/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.web.core.handler;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.jrack.core.exception.ErrorCode;
import cn.jrack.core.exception.ServiceException;
import cn.jrack.core.exception.enums.GlobalErrorCodeConstants;
import cn.jrack.core.util.web.response.Result;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    public Result<?> allExceptionHandler(HttpServletRequest request, Throwable ex) {
        if (ex instanceof MissingServletRequestParameterException) {
            return this.missingServletRequestParameterExceptionHandler((MissingServletRequestParameterException)ex);
        }
        if (ex instanceof MethodArgumentTypeMismatchException) {
            return this.methodArgumentTypeMismatchExceptionHandler((MethodArgumentTypeMismatchException)ex);
        }
        if (ex instanceof MethodArgumentNotValidException) {
            return this.methodArgumentNotValidExceptionExceptionHandler((MethodArgumentNotValidException)ex);
        }
        if (ex instanceof BindException) {
            return this.bindExceptionHandler((BindException)ex);
        }
        if (ex instanceof NoHandlerFoundException) {
            return this.noHandlerFoundExceptionHandler((NoHandlerFoundException)ex);
        }
        if (ex instanceof HttpRequestMethodNotSupportedException) {
            return this.httpRequestMethodNotSupportedExceptionHandler((HttpRequestMethodNotSupportedException)ex);
        }
        if (ex instanceof ServiceException) {
            return this.serviceExceptionHandler((ServiceException)ex);
        }
        if (ex instanceof SaTokenException) {
            return this.saTokenExceptionHandler((SaTokenException)ex);
        }
        if (ex instanceof NotLoginException) {
            return this.notLoginExceptionHandler((NotLoginException)ex);
        }
        return this.defaultExceptionHandler(request, ex);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<?> missingServletRequestParameterExceptionHandler(MissingServletRequestParameterException ex) {
        log.warn("[missingServletRequestParameterExceptionHandler]", (Throwable)ex);
        return Result.failure((int)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931:%s", ex.getParameterName()));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Result<?> methodArgumentTypeMismatchExceptionHandler(MethodArgumentTypeMismatchException ex) {
        log.warn("[missingServletRequestParameterExceptionHandler]", (Throwable)ex);
        return Result.failure((int)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u9519\u8bef:%s", ex.getMessage()));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<?> methodArgumentNotValidExceptionExceptionHandler(MethodArgumentNotValidException ex) {
        log.warn("[methodArgumentNotValidExceptionExceptionHandler]", (Throwable)ex);
        FieldError fieldError = ex.getBindingResult().getFieldError();
        assert (fieldError != null);
        return Result.failure((int)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e:%s", fieldError.getDefaultMessage()));
    }

    @ExceptionHandler(value={BindException.class})
    public Result<?> bindExceptionHandler(BindException ex) {
        log.warn("[handleBindException]", (Throwable)ex);
        FieldError fieldError = ex.getFieldError();
        assert (fieldError != null);
        return Result.failure((int)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e:%s", fieldError.getDefaultMessage()));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<?> constraintViolationExceptionHandler(ConstraintViolationException ex) {
        log.warn("[constraintViolationExceptionHandler]", (Throwable)ex);
        ConstraintViolation constraintViolation = (ConstraintViolation)ex.getConstraintViolations().iterator().next();
        return Result.failure((int)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e:%s", constraintViolation.getMessage()));
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Result<?> noHandlerFoundExceptionHandler(NoHandlerFoundException ex) {
        log.warn("[noHandlerFoundExceptionHandler]", (Throwable)ex);
        return Result.failure((int)GlobalErrorCodeConstants.NOT_FOUND.getCode(), (String)String.format("\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728:%s", ex.getRequestURL()));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<?> httpRequestMethodNotSupportedExceptionHandler(HttpRequestMethodNotSupportedException ex) {
        log.warn("[httpRequestMethodNotSupportedExceptionHandler]", (Throwable)ex);
        return Result.failure((int)GlobalErrorCodeConstants.METHOD_NOT_ALLOWED.getCode(), (String)String.format("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u6b63\u786e:%s", ex.getMessage()));
    }

    @ExceptionHandler(value={SaTokenException.class})
    public Result<?> saTokenExceptionHandler(SaTokenException ex) {
        log.warn("[saTokenExceptionHandler]", (Throwable)ex);
        return Result.failure((ErrorCode)new ErrorCode(GlobalErrorCodeConstants.FORBIDDEN.getCode(), ex.getMessage()));
    }

    @ExceptionHandler(value={ServiceException.class})
    public Result<?> serviceExceptionHandler(ServiceException ex) {
        log.info("[serviceExceptionHandler]", (Throwable)ex);
        return Result.failure((int)ex.getCode(), (String)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public Result<?> defaultExceptionHandler(HttpServletRequest req, Throwable ex) {
        log.error("[defaultExceptionHandler]", ex);
        this.createExceptionLog(req, ex);
        return Result.failure((int)GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode(), (String)GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getMsg());
    }

    @ExceptionHandler(value={NotLoginException.class})
    public Result<?> notLoginExceptionHandler(NotLoginException ex) {
        log.error("[defaultExceptionHandler]", (Throwable)ex);
        this.createExceptionLog(null, (Throwable)ex);
        return Result.failure((int)GlobalErrorCodeConstants.UNAUTHORIZED.getCode(), (String)ex.getMessage());
    }

    private void createExceptionLog(HttpServletRequest req, Throwable e) {
    }
}

