/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.jackson.core.databind;

import cn.jrack.core.util.common.StringUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class LocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();
    private static final String defaultPattern = "yyyy-MM-dd HH:mm:ss";

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = jsonParser.getText();
        if (StringUtil.isEmpty((String)text)) {
            return null;
        }
        if (text.length() == 13 || text.length() == 10) {
            return LocalDateTime.parse(text);
        }
        if (text.contains("T") && text.contains("SSSZ")) {
            return LocalDateTime.parse(text);
        }
        return LocalDateTime.parse(text);
    }
}

