/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.jackson.core.databind;

import cn.jrack.core.util.common.StringUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class DateDeserializer
extends JsonDeserializer<Date> {
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat SSSZ_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        try {
            String text = jsonParser.getText();
            if (StringUtil.isEmpty((String)text)) {
                return null;
            }
            if (text.length() == 13 || text.length() == 10) {
                return DEFAULT_DATE_FORMAT.parse(DEFAULT_DATE_FORMAT.format(Long.parseLong(text)));
            }
            if (text.contains("T") && text.contains("SSSZ")) {
                return SSSZ_DATE_FORMAT.parse(text);
            }
            return DEFAULT_DATE_FORMAT.parse(text);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

