/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.test.core.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.jrack.core.enums.CommonStatusEnum;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.co.jemos.podam.api.PodamFactory;
import uk.co.jemos.podam.api.PodamFactoryImpl;

public class RandomUtil {
    private static final int RANDOM_STRING_LENGTH = 10;
    private static final int TINYINT_MAX = 127;
    private static final int RANDOM_DATE_MAX = 30;
    private static final int RANDOM_COLLECTION_LENGTH = 5;
    private static final PodamFactory PODAM_FACTORY = new PodamFactoryImpl();

    public static String randomString() {
        return cn.hutool.core.util.RandomUtil.randomString((int)10);
    }

    public static Long randomLongId() {
        return cn.hutool.core.util.RandomUtil.randomLong((long)0L, (long)Long.MAX_VALUE);
    }

    public static Integer randomInteger() {
        return cn.hutool.core.util.RandomUtil.randomInt((int)0, (int)Integer.MAX_VALUE);
    }

    public static Date randomDate() {
        return cn.hutool.core.util.RandomUtil.randomDay((int)0, (int)30);
    }

    public static Short randomShort() {
        return (short)cn.hutool.core.util.RandomUtil.randomInt((int)0, (int)Short.MAX_VALUE);
    }

    public static <T> Set<T> randomSet(Class<T> clazz) {
        return Stream.iterate(0, i -> i).limit(cn.hutool.core.util.RandomUtil.randomInt((int)1, (int)5)).map(i -> RandomUtil.randomPojo(clazz, new Consumer[0])).collect(Collectors.toSet());
    }

    public static Integer randomCommonStatus() {
        return ((CommonStatusEnum)cn.hutool.core.util.RandomUtil.randomEle((Object[])CommonStatusEnum.values())).getStatus();
    }

    @SafeVarargs
    public static <T> T randomPojo(Class<T> clazz, Consumer<T> ... consumers) {
        Object pojo = PODAM_FACTORY.manufacturePojo(clazz, new Type[0]);
        if (ArrayUtil.isNotEmpty((Object[])consumers)) {
            Arrays.stream(consumers).forEach(consumer -> consumer.accept(pojo));
        }
        return (T)pojo;
    }

    @SafeVarargs
    public static <T> T randomPojo(Class<T> clazz, Type type, Consumer<T> ... consumers) {
        Object pojo = PODAM_FACTORY.manufacturePojo(clazz, new Type[]{type});
        if (ArrayUtil.isNotEmpty((Object[])consumers)) {
            Arrays.stream(consumers).forEach(consumer -> consumer.accept(pojo));
        }
        return (T)pojo;
    }

    @SafeVarargs
    public static <T> List<T> randomPojoList(Class<T> clazz, Consumer<T> ... consumers) {
        int size = cn.hutool.core.util.RandomUtil.randomInt((int)1, (int)5);
        return Stream.iterate(0, i -> i).limit(size).map(o -> RandomUtil.randomPojo(clazz, consumers)).collect(Collectors.toList());
    }

    static {
        PODAM_FACTORY.getStrategy().addOrReplaceTypeManufacturer(String.class, (dataProviderStrategy, attributeMetadata, map) -> RandomUtil.randomString());
        PODAM_FACTORY.getStrategy().addOrReplaceTypeManufacturer(Integer.class, (dataProviderStrategy, attributeMetadata, map) -> {
            if (attributeMetadata.getAttributeName().equals("status")) {
                return ((CommonStatusEnum)cn.hutool.core.util.RandomUtil.randomEle((Object[])CommonStatusEnum.values())).getStatus();
            }
            if (StrUtil.endWithAnyIgnoreCase((CharSequence)attributeMetadata.getAttributeName(), (CharSequence[])new CharSequence[]{"type", "status", "category", "scope"})) {
                return cn.hutool.core.util.RandomUtil.randomInt((int)0, (int)128);
            }
            return cn.hutool.core.util.RandomUtil.randomInt();
        });
        PODAM_FACTORY.getStrategy().addOrReplaceTypeManufacturer(Boolean.class, (dataProviderStrategy, attributeMetadata, map) -> {
            if (attributeMetadata.getAttributeName().equals("deleted")) {
                return false;
            }
            return cn.hutool.core.util.RandomUtil.randomBoolean();
        });
    }
}

