/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.test.core.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.jrack.core.exception.ErrorCode;
import cn.jrack.core.exception.ServiceException;
import cn.jrack.core.exception.util.ServiceExceptionUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public class AssertUtil {
    public static void assertPojoEquals(Object expected, Object actual, String ... ignoreFields) {
        Field[] expectedFields = ReflectUtil.getFields(expected.getClass());
        Arrays.stream(expectedFields).forEach(expectedField -> {
            if (ArrayUtil.contains((Object[])ignoreFields, (Object)expectedField.getName())) {
                return;
            }
            Field actualField = ReflectUtil.getField(actual.getClass(), (String)expectedField.getName());
            if (actualField == null) {
                return;
            }
            Assertions.assertEquals((Object)ReflectUtil.getFieldValue((Object)expected, (Field)expectedField), (Object)ReflectUtil.getFieldValue((Object)actual, (Field)actualField), (String)String.format("Field(%s) \u4e0d\u5339\u914d", expectedField.getName()));
        });
    }

    public static boolean isPojoEquals(Object expected, Object actual, String ... ignoreFields) {
        Field[] expectedFields = ReflectUtil.getFields(expected.getClass());
        return Arrays.stream(expectedFields).allMatch(expectedField -> {
            if (ArrayUtil.contains((Object[])ignoreFields, (Object)expectedField.getName())) {
                return true;
            }
            Field actualField = ReflectUtil.getField(actual.getClass(), (String)expectedField.getName());
            if (actualField == null) {
                return true;
            }
            return Objects.equals(ReflectUtil.getFieldValue((Object)expected, (Field)expectedField), ReflectUtil.getFieldValue((Object)actual, (Field)actualField));
        });
    }

    public static void assertServiceException(Executable executable, ErrorCode errorCode, Object ... messageParams) {
        ServiceException serviceException = (ServiceException)Assertions.assertThrows(ServiceException.class, (Executable)executable);
        Assertions.assertEquals((Integer)errorCode.getCode(), (Integer)serviceException.getCode(), (String)"\u9519\u8bef\u7801\u4e0d\u5339\u914d");
        String message = ServiceExceptionUtil.doFormat((int)errorCode.getCode(), (String)errorCode.getMsg(), (Object[])messageParams);
        Assertions.assertEquals((Object)message, (Object)serviceException.getMessage(), (String)"\u9519\u8bef\u63d0\u793a\u4e0d\u5339\u914d");
    }
}

