package cn.jrack.springboot.satoken.core.util;


import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import cn.jrack.core.constant.SystemConstant;
import cn.jrack.springboot.satoken.core.StUserInfo;
import cn.jrack.springboot.satoken.core.constant.JrackSaTokenConstant;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class SaTokenUtils {


    public static final String LOGIN_ID = SystemConstant.NAME + "_token_login_id_";


    /**
     * @des 是否登录
     */
    public static boolean isLogin() {
        return StpUtil.isLogin();
    }

    /**
     * @des 获取登录Id
     */
    public static Object getLoginId() {
        return StpUtil.getLoginId();
    }


    public static void login(Object loginId, StUserInfo loginUserInfo) {
        login(loginId, loginUserInfo, false);
    }

    public static void login(Object loginId, StUserInfo loginUserInfo, Boolean isCreate) {
        StpUtil.login(loginId);
        loginUserInfo.setLastLoginTime(LocalDateTime.now());
        loginUserInfo.setToken(StpUtil.getTokenValue());
//        loginUserInfo.setLoginDevice(StpUtil.getLoginDevice());
//        loginUserInfo.setLoginType(StpUtil.getLoginType());
        HashMap map = new HashMap();
        map.put("sessionTimeout", StpUtil.getSessionTimeout());
        map.put("tokenActivityTimeout", StpUtil.getTokenActivityTimeout());
        map.put("tokenTimeout", StpUtil.getTokenTimeout());
        map.put("safeTimeout", StpUtil.getSafeTime());
        loginUserInfo.setData(map);
        StpUtil.getSession(isCreate).set(LOGIN_ID + StpUtil.getLoginId(), loginUserInfo);
    }

    public static StUserInfo getLoginUserInfo(Object loginId) {
        return (StUserInfo) StpUtil.getSession(false).get(LOGIN_ID + loginId);
    }

    public static List<StUserInfo> getUserListOnLine(String keyWord) {
        // 返回数据对象
        List<StUserInfo> list = new ArrayList<>();
        // 获取所有登录的用户ids
        List<String> logIds = StpUtil.searchSessionId(keyWord, 0, -1, false);
        // 便利获取登录信息
        SaSession session = null;
        for (int i = 0; i < logIds.size(); i++) {
            session = StpUtil.getSessionBySessionId(logIds.get(i));
            String id = session.getId();
            String sessionKey = JrackSaTokenConstant.TOKEN_NAME + ":login:session:";
            id = id.replace(sessionKey, SaTokenUtils.LOGIN_ID);
            StUserInfo model = session.getModel(id, StUserInfo.class);
            Map<String, Object> dataMap = session.getDataMap();
            list.add(model);
        }
        return list;

    }



    /*
     * @description : 获取租户id
     * @param
     * @return : java.lang.String
     * @author : Joy
     * @date : 2024/1/23
     */
    public static String getTenantId() {
        return getLoginUserInfo().getTenantId();
    }

    public static StUserInfo getLoginUserInfo() {
        return (StUserInfo) StpUtil.getSession(false).get(LOGIN_ID + StpUtil.getLoginId());
    }

    public static StUserInfo getLoginUserInfo(String token) {

        return (StUserInfo) StpUtil.getSession(false).get(LOGIN_ID + StpUtil.getTokenValueByLoginId(token));
    }

    public static void logout() {

        logout(StpUtil.getLoginId());
    }


    public static void logout(Object loginId) {

        StpUtil.logout(LOGIN_ID + loginId);
        StpUtil.getSession(false).delete(LOGIN_ID + loginId);

    }


    public static void kickout(Object loginId) {
        StpUtil.kickout(loginId);
    }

    public static void checkLogin() {
        StpUtil.checkLogin();
    }

    public static String getTokenValue() {
        return StpUtil.getTokenValue();
    }

    public static Object getLoginIdByToken() {
        return getLoginIdByToken(StpUtil.getTokenValue());
    }

    public static Object getLoginIdByToken(String tokenValue) {
        return StpUtil.getLoginIdByToken(tokenValue);
    }

    public static SaSession getSessionByLoginId(Object loginId) {
        return StpUtil.getSessionByLoginId(loginId);
    }


    public static void main(String[] args) {
        login(10001, new StUserInfo());
        System.out.println(getTokenValue());
    }

}
