/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.satoken.core.util;

import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import cn.jrack.core.constant.SystemConstant;
import cn.jrack.springboot.satoken.core.StUserInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SaTokenUtils {
    public static final String LOGIN_ID = SystemConstant.NAME + "_token_login_id_";

    public static boolean isLogin() {
        return StpUtil.isLogin();
    }

    public static Object getLoginId() {
        return StpUtil.getLoginId();
    }

    public static void login(Object loginId, StUserInfo loginUserInfo) {
        SaTokenUtils.login(loginId, loginUserInfo, false);
    }

    public static void login(Object loginId, StUserInfo loginUserInfo, Boolean isCreate) {
        StpUtil.login((Object)loginId);
        loginUserInfo.setLastLoginTime(LocalDateTime.now());
        loginUserInfo.setToken(StpUtil.getTokenValue());
        loginUserInfo.setLoginDevice(StpUtil.getLoginDevice());
        loginUserInfo.setLoginType(StpUtil.getLoginType());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("sessionTimeout", StpUtil.getSessionTimeout());
        map.put("tokenActivityTimeout", StpUtil.getTokenActivityTimeout());
        map.put("tokenTimeout", StpUtil.getTokenTimeout());
        map.put("safeTimeout", StpUtil.getSafeTime());
        loginUserInfo.setData(map);
        StpUtil.getSession((boolean)isCreate).set(LOGIN_ID + StpUtil.getLoginId(), (Object)loginUserInfo);
    }

    public static StUserInfo getLoginUserInfo(Object loginId) {
        return (StUserInfo)StpUtil.getSession((boolean)false).get(LOGIN_ID + loginId);
    }

    public static List<StUserInfo> getUserListOnLine(String keyWord) {
        ArrayList<StUserInfo> list = new ArrayList<StUserInfo>();
        List logIds = StpUtil.searchSessionId((String)keyWord, (int)0, (int)-1, (boolean)false);
        SaSession session = null;
        for (int i = 0; i < logIds.size(); ++i) {
            session = StpUtil.getSessionBySessionId((String)((String)logIds.get(i)));
            String id = session.getId();
            String sessionKey = "JRACKTOKEN:login:session:";
            id = id.replace(sessionKey, LOGIN_ID);
            StUserInfo model = (StUserInfo)session.getModel(id, StUserInfo.class);
            Map dataMap = session.getDataMap();
            list.add(model);
        }
        return list;
    }

    public static String getTenantId() {
        return SaTokenUtils.getLoginUserInfo().getTenantId();
    }

    public static StUserInfo getLoginUserInfo() {
        return (StUserInfo)StpUtil.getSession((boolean)false).get(LOGIN_ID + StpUtil.getLoginId());
    }

    public static StUserInfo getLoginUserInfo(String token) {
        return (StUserInfo)StpUtil.getSession((boolean)false).get(LOGIN_ID + StpUtil.getTokenValueByLoginId((Object)token));
    }

    public static void logout() {
        StpUtil.logout((Object)(LOGIN_ID + StpUtil.getLoginId()));
        StpUtil.getSession((boolean)false).delete(LOGIN_ID + StpUtil.getLoginId());
    }

    public static void checkLogin() {
        StpUtil.checkLogin();
    }

    public static String getTokenValue() {
        return StpUtil.getTokenValue();
    }

    public static void main(String[] args) {
        SaTokenUtils.login(10001, new StUserInfo());
        System.out.println(SaTokenUtils.getTokenValue());
    }
}

