/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.satoken.core.router;

import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpUtil;
import cn.jrack.springboot.core.util.SpringUtil;
import cn.jrack.springboot.satoken.core.annotation.Ignore;
import cn.jrack.springboot.satoken.core.handler.IgnoreHandler;
import java.util.Collection;
import java.util.Objects;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class IgnoreSaRouter
implements SaFunction {
    private final Object handler;

    public IgnoreSaRouter(Object handler) {
        this.handler = handler;
    }

    public void run() {
        Collection valuesByBeanType = SpringUtil.getValuesByBeanType(IgnoreHandler.class);
        for (IgnoreHandler v : valuesByBeanType) {
            if (!v.checkBeforeIgnoreLogin(this.handler).booleanValue()) continue;
            SaRouter.stop();
        }
        if (this.handler instanceof ResourceHttpRequestHandler) {
            SaRouter.stop();
        }
        if (this.handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)this.handler;
            Ignore ignoreAuth = (Ignore)handlerMethod.getMethodAnnotation(Ignore.class);
            Ignore ignoreAuthClass = handlerMethod.getBean().getClass().getDeclaredAnnotation(Ignore.class);
            if (Objects.nonNull(ignoreAuth) && ignoreAuth.type().equals("LOGIN")) {
                SaRouter.stop();
            }
            if (Objects.nonNull(ignoreAuthClass) && ignoreAuthClass.type().equals("LOGIN")) {
                SaRouter.stop();
            }
        }
        for (IgnoreHandler v : valuesByBeanType) {
            if (!v.checkAfterIgnoreLogin(this.handler).booleanValue()) continue;
            SaRouter.stop();
        }
        StpUtil.checkLogin();
    }
}

