package cn.jrack.springboot.satoken.core;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class StUserInfo {


    /// <summary>
    /// 用户主键
    /// </summary>
    private String userId;
    /// <summary>
    /// 账号
    /// </summary>
    private String userName;
    /// <summary>
    /// 编号
    /// </summary>
    private String code;
    /// <summary>
    /// 账户
    /// </summary>
    private String account;
    /// <summary>
    /// 密码秘钥
    /// </summary>
    private String secretKey;
    /// <summary>
    /// 真实姓名
    /// </summary>
    private String realName;
    /// <summary>
    /// 呢称
    /// </summary>
    private String nickName;
    /// <summary>
    /// 头像
    /// </summary>
    private String headIcon;
    /// <summary>
    /// 性别
    /// </summary>
    private int gender;
    /// <summary>
    /// 手机
    /// </summary>
    private String mobile;
    /// <summary>
    /// 电话
    /// </summary>
    private String telephone;
    /// <summary>
    /// 电子邮件
    /// </summary>
    private String email;
    /// <summary>
    /// QQ号
    /// </summary>
    private String oICQ;
    /// <summary>
    /// 微信号
    /// </summary>
    private String weChat;
    /// <summary>
    /// 公司主键
    /// </summary>
    private String companyId;
    /// <summary>
    /// 所在公司及下属公司
    /// </summary>
    private List<String> companyIds;

    /// <summary>
    /// 所在组织架构节点
    /// </summary>
    private String organizationIds;
    /// <summary>
    /// 部门主键
    /// </summary>
    private String departmentId;
    /// <summary>
    /// 所在部门及下属部门
    /// </summary>
    private List<String> departmentIds;
    /// <summary>
    /// 单点登录标识
    /// </summary>
    private String openId;
    /// <summary>
    /// 角色信息
    /// </summary>
    private String roleIds;
    /// <summary>
    /// 职位信息
    /// </summary>
    private String positionIds;
    /// <summary>
    /// 是否是超级管理员
    /// </summary>
    private Boolean isSystem;

    /// <summary>
    /// 应用Id
    /// </summary>
    private String appId;
    /// <summary>
    /// 登录时间
    /// </summary>
    private Date loginTime;
    /// <summary>
    /// 登录IP地址
    /// </summary>
    private String iPAddress;
    /// <summary>
    /// 浏览器名称
    /// </summary>
    private String browser;
    /// <summary>
    /// 登录者标识
    /// </summary>
    private String loginMark;
    /// <summary>
    /// 令牌信息
    /// </summary>
    private String token;
    /// <summary>
    /// 租户Id
    /// </summary>
    private String tenantId;
    /// <summary>
    /// 即时通讯地址
    /// </summary>
    private String imUrl;


    private Map data;


    /*
     * @description : 用户类型
     */
    private String userType;

    /*
     * @description : 最后更新密码时间
     * @param null
     * @return :
     * @author : Joy
     * @date : 2023/7/13
     */
    private LocalDateTime lastUpdatePasswordTime;

    /*
     * @description : 最后登录时间
     * @param null 
     * @return :
     * @author : Joy
     * @date : 2023/7/13
     */
    private LocalDateTime lastLoginTime;

    /*
     * @description : IP地址
     * @param null
     * @return :
     * @author : Joy
     * @date : 2023/7/13
     */
    private String loginIp;


    //登录类型
    private String loginType;

    //登录设备
    private String loginDevice;


}
