/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.satoken.config;

import cn.dev33.satoken.config.SaCookieConfig;
import cn.dev33.satoken.util.SaFoxUtil;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="jrack.sa-token")
public class SaTokenProperties {
    private static final long serialVersionUID = -6541180061782004705L;
    private String tokenName = "JRACKTOKEN";
    private long timeout = 2592000L;
    private long activityTimeout = -1L;
    private Boolean isConcurrent = true;
    private Boolean isShare = true;
    private int maxLoginCount = 12;
    private Boolean isReadBody = true;
    private Boolean isReadHeader = true;
    private Boolean isReadCookie = true;
    private Boolean isWriteHeader = false;
    private String tokenStyle = "uuid";
    private int dataRefreshPeriod = 30;
    private Boolean tokenSessionCheckLogin = true;
    private Boolean autoRenew = true;
    private String tokenPrefix;
    private Boolean isPrint = true;
    private Boolean isLog = false;
    private String logLevel = "trace";
    private int logLevelInt = 1;
    private String jwtSecretKey;
    private String basic = "";
    private String currDomain;
    private long sameTokenTimeout = 86400L;
    private Boolean checkSameToken = false;
    public SaCookieConfig cookie = new SaCookieConfig();

    public String getTokenName() {
        return this.tokenName;
    }

    public SaTokenProperties setTokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public SaTokenProperties setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public long getActivityTimeout() {
        return this.activityTimeout;
    }

    public SaTokenProperties setActivityTimeout(long activityTimeout) {
        this.activityTimeout = activityTimeout;
        return this;
    }

    public Boolean getIsConcurrent() {
        return this.isConcurrent;
    }

    public SaTokenProperties setIsConcurrent(Boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
        return this;
    }

    public Boolean getIsShare() {
        return this.isShare;
    }

    public SaTokenProperties setIsShare(Boolean isShare) {
        this.isShare = isShare;
        return this;
    }

    public int getMaxLoginCount() {
        return this.maxLoginCount;
    }

    public SaTokenProperties setMaxLoginCount(int maxLoginCount) {
        this.maxLoginCount = maxLoginCount;
        return this;
    }

    public Boolean getIsReadBody() {
        return this.isReadBody;
    }

    public SaTokenProperties setIsReadBody(Boolean isReadBody) {
        this.isReadBody = isReadBody;
        return this;
    }

    public Boolean getIsReadHeader() {
        return this.isReadHeader;
    }

    public SaTokenProperties setIsReadHeader(Boolean isReadHeader) {
        this.isReadHeader = isReadHeader;
        return this;
    }

    public Boolean getIsReadCookie() {
        return this.isReadCookie;
    }

    public SaTokenProperties setIsReadCookie(Boolean isReadCookie) {
        this.isReadCookie = isReadCookie;
        return this;
    }

    public Boolean getIsWriteHeader() {
        return this.isWriteHeader;
    }

    public SaTokenProperties setIsWriteHeader(Boolean isWriteHeader) {
        this.isWriteHeader = isWriteHeader;
        return this;
    }

    public String getTokenStyle() {
        return this.tokenStyle;
    }

    public SaTokenProperties setTokenStyle(String tokenStyle) {
        this.tokenStyle = tokenStyle;
        return this;
    }

    public int getDataRefreshPeriod() {
        return this.dataRefreshPeriod;
    }

    public SaTokenProperties setDataRefreshPeriod(int dataRefreshPeriod) {
        this.dataRefreshPeriod = dataRefreshPeriod;
        return this;
    }

    public Boolean getTokenSessionCheckLogin() {
        return this.tokenSessionCheckLogin;
    }

    public SaTokenProperties setTokenSessionCheckLogin(Boolean tokenSessionCheckLogin) {
        this.tokenSessionCheckLogin = tokenSessionCheckLogin;
        return this;
    }

    public Boolean getAutoRenew() {
        return this.autoRenew;
    }

    public SaTokenProperties setAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    public String getTokenPrefix() {
        return this.tokenPrefix;
    }

    public SaTokenProperties setTokenPrefix(String tokenPrefix) {
        this.tokenPrefix = tokenPrefix;
        return this;
    }

    public Boolean getIsPrint() {
        return this.isPrint;
    }

    public SaTokenProperties setIsPrint(Boolean isPrint) {
        this.isPrint = isPrint;
        return this;
    }

    public Boolean getIsLog() {
        return this.isLog;
    }

    public SaTokenProperties setIsLog(Boolean isLog) {
        this.isLog = isLog;
        return this;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public SaTokenProperties setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        this.logLevelInt = SaFoxUtil.translateLogLevelToInt((String)logLevel);
        return this;
    }

    public int getLogLevelInt() {
        return this.logLevelInt;
    }

    public SaTokenProperties setLogLeveInt(int logLevelInt) {
        this.logLevelInt = logLevelInt;
        this.logLevel = SaFoxUtil.translateLogLevelToString((int)logLevelInt);
        return this;
    }

    public String getJwtSecretKey() {
        return this.jwtSecretKey;
    }

    public SaTokenProperties setJwtSecretKey(String jwtSecretKey) {
        this.jwtSecretKey = jwtSecretKey;
        return this;
    }

    public String getBasic() {
        return this.basic;
    }

    public SaTokenProperties setBasic(String basic) {
        this.basic = basic;
        return this;
    }

    public String getCurrDomain() {
        return this.currDomain;
    }

    public SaTokenProperties setCurrDomain(String currDomain) {
        this.currDomain = currDomain;
        return this;
    }

    public long getSameTokenTimeout() {
        return this.sameTokenTimeout;
    }

    public SaTokenProperties setSameTokenTimeout(long sameTokenTimeout) {
        this.sameTokenTimeout = sameTokenTimeout;
        return this;
    }

    public Boolean getCheckSameToken() {
        return this.checkSameToken;
    }

    public SaTokenProperties setCheckSameToken(Boolean checkSameToken) {
        this.checkSameToken = checkSameToken;
        return this;
    }

    public SaCookieConfig getCookie() {
        return this.cookie;
    }

    public SaTokenProperties setCookie(SaCookieConfig cookie) {
        this.cookie = cookie;
        return this;
    }

    public String toString() {
        return "SaTokenProperties [tokenName=" + this.tokenName + ", timeout=" + this.timeout + ", activityTimeout=" + this.activityTimeout + ", isConcurrent=" + this.isConcurrent + ", isShare=" + this.isShare + ", maxLoginCount=" + this.maxLoginCount + ", isReadBody=" + this.isReadBody + ", isReadHeader=" + this.isReadHeader + ", isReadCookie=" + this.isReadCookie + ", isWriteHeader=" + this.isWriteHeader + ", tokenStyle=" + this.tokenStyle + ", dataRefreshPeriod=" + this.dataRefreshPeriod + ", tokenSessionCheckLogin=" + this.tokenSessionCheckLogin + ", autoRenew=" + this.autoRenew + ", tokenPrefix=" + this.tokenPrefix + ", isPrint=" + this.isPrint + ", isLog=" + this.isLog + ", logLevel=" + this.logLevel + ", logLevelInt=" + this.logLevelInt + ", jwtSecretKey=" + this.jwtSecretKey + ", basic=" + this.basic + ", currDomain=" + this.currDomain + ", sameTokenTimeout=" + this.sameTokenTimeout + ", checkSameToken=" + this.checkSameToken + ", cookie=" + this.cookie + "]";
    }

    @Deprecated
    public Boolean getIsReadHead() {
        return this.isReadHeader;
    }

    @Deprecated
    public SaTokenProperties setIsReadHead(Boolean isReadHead) {
        this.isReadHeader = isReadHead;
        return this;
    }

    @Deprecated
    public long getIdTokenTimeout() {
        return this.sameTokenTimeout;
    }

    @Deprecated
    public SaTokenProperties setIdTokenTimeout(long idTokenTimeout) {
        this.sameTokenTimeout = idTokenTimeout;
        return this;
    }

    @Deprecated
    public Boolean getCheckIdToken() {
        return this.checkSameToken;
    }

    @Deprecated
    public SaTokenProperties setCheckIdToken(Boolean checkIdToken) {
        this.checkSameToken = checkIdToken;
        return this;
    }
}

