package cn.jrack.springboot.satoken.core.util;


import cn.dev33.satoken.stp.StpUtil;
import cn.jrack.core.constant.SystemConstant;
import cn.jrack.springboot.satoken.core.StUserInfo;

import java.time.LocalDateTime;


public class SaTokenUtils {


    public static final String LOGIN_ID = SystemConstant.NAME + "_token_login_id_";


    /**
     * @des 是否登录
     */
    public static boolean isLogin() {
        return StpUtil.isLogin();
    }

    /**
     * @des 获取登录Id
     */
    public static Object getLoginId() {
        return StpUtil.getLoginId();
    }


    public static void login(Object loginId, StUserInfo loginUserInfo) {
        login(loginId, loginUserInfo, false);
    }

    public static void login(Object loginId, StUserInfo loginUserInfo, Boolean isCreate) {
        StpUtil.login(loginId);
        loginUserInfo.setLastLoginTime(LocalDateTime.now());
        StpUtil.getSession(isCreate).set(LOGIN_ID + StpUtil.getLoginId(), loginUserInfo);
    }

    public static StUserInfo getLoginUserInfo(Object loginId) {
        return (StUserInfo) StpUtil.getSession(false).get(LOGIN_ID + loginId);
    }


    /*
     * @description : 获取租户id
     * @param
     * @return : java.lang.String
     * @author : Joy
     * @date : 2024/1/23
     */
    public static String getTenantId() {
        return getLoginUserInfo().getTenantId();
    }

    public static StUserInfo getLoginUserInfo() {
        return (StUserInfo) StpUtil.getSession(false).get(LOGIN_ID + StpUtil.getLoginId());
    }

    public static StUserInfo getLoginUserInfo(String token) {

        return (StUserInfo) StpUtil.getSession(false).get(LOGIN_ID + StpUtil.getTokenValueByLoginId(token));
    }

    public static void logout() {


        StpUtil.logout(LOGIN_ID + StpUtil.getLoginId());
        StpUtil.getSession(false).delete(LOGIN_ID + StpUtil.getLoginId());

    }

    public static void checkLogin() {
        StpUtil.checkLogin();
    }

    public static String getTokenValue() {
        return StpUtil.getTokenValue();
    }


    public static void main(String[] args) {
        login(10001, new StUserInfo());
        System.out.println(getTokenValue());
    }

}
