package cn.jrack.springboot.satoken.config;


import cn.dev33.satoken.config.SaTokenConfig;
import cn.jrack.springboot.satoken.core.handler.IgnoreHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.*;

import javax.annotation.Resource;


//todo 后续调整属性配置
//@EnableConfigurationProperties(SaTokenProperties.class)
//关闭启动了，为了支持SSO
@Configuration
@ComponentScan(basePackages = {"*"},
        includeFilters = {@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = IgnoreHandler.class)}, useDefaultFilters = false
)
@EnableConfigurationProperties({SaTokenProperties.class})
public class JkAutoSaTokenConfigure {


    @Resource
    private SaTokenProperties SaTokenProperties;

    // Sa-Token 参数配置，参考文档：https://sa-token.cc
    // 此配置会覆盖 application.yml 中的配置
//    @Bean
//    @Primary
//    public SaTokenConfig getSaTokenConfigPrimary() {
//        SaTokenConfig config = new SaTokenConfig();
//        config.setTokenName("satoken");             // token名称 (同时也是cookie名称)
//        config.setTimeout(30 * 24 * 60 * 60);       // token有效期，单位s 默认30天
//        config.setActivityTimeout(-1);              // token临时有效期 (指定时间内无操作就视为token过期) 单位: 秒
//        config.setIsConcurrent(true);               // 是否允许同一账号并发登录 (为true时允许一起登录, 为false时新登录挤掉旧登录)
//        config.setIsShare(true);                    // 在多人登录同一账号时，是否共用一个token (为true时所有登录共用一个token, 为false时每次登录新建一个token)
//        config.setTokenStyle("uuid");               // token风格
//        config.setIsLog(false);                     // 是否输出操作日志
//        return config;
//    }

    // Sa-Token 参数配置，参考文档：https://sa-token.cc
    // 此配置会与 application.yml 中的配置合并 （代码配置优先）
    @Autowired
    public void configSaToken(SaTokenConfig config) {
        config.setTokenName("JKTOKEN");             // token名称 (同时也是cookie名称)
        //config.setTimeout(30 * 24 * 60 * 60);       // token有效期，单位s 默认30天
        config.setTimeout(SaTokenProperties.getTimeout());       // token有效期，单位s 默认30天
        config.setActivityTimeout(SaTokenProperties.getActivityTimeout());              // token临时有效期 (指定时间内无操作就视为token过期) 单位: 秒
        config.setIsConcurrent(SaTokenProperties.getIsConcurrent());               // 是否允许同一账号并发登录 (为true时允许一起登录, 为false时新登录挤掉旧登录)
        config.setIsShare(SaTokenProperties.getIsShare());                    // 在多人登录同一账号时，是否共用一个token (为true时所有登录共用一个token, 为false时每次登录新建一个token)
        config.setTokenStyle("uuid");               // token风格
        config.setIsLog(SaTokenProperties.getIsLog());                     // 是否输出操作日志
    }

}
