package cn.jrack.springboot.satoken.core.router;


import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpUtil;
import cn.jrack.springboot.core.util.SpringUtil;
import cn.jrack.springboot.satoken.core.annotation.Ignore;
import cn.jrack.springboot.satoken.core.handler.IgnoreHandler;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

import java.util.Collection;
import java.util.Objects;

/**
 * 鉴权路由配置类
 *
 * @author ZhaoYang
 */
public class IgnoreSaRouter implements SaFunction {
    private final Object handler;


    public IgnoreSaRouter(Object handler) {
        this.handler = handler;
    }

    @Override
    public void run() {
//        SaRouter.stop();

        Collection<IgnoreHandler> valuesByBeanType = SpringUtil.getValuesByBeanType(IgnoreHandler.class);
        for (IgnoreHandler v :
                valuesByBeanType) {
            if (v.checkBeforeIgnoreLogin(handler)) {
                SaRouter.stop();
            }
        }

        if (handler instanceof ResourceHttpRequestHandler) {
            SaRouter.stop();
        }
        // 注解跳过鉴权
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            Ignore ignoreAuth = handlerMethod.getMethodAnnotation(Ignore.class);
            Ignore ignoreAuthClass = handlerMethod.getBean().getClass().getDeclaredAnnotation(Ignore.class);
            if (Objects.nonNull(ignoreAuth) && ignoreAuth.type().equals("LOGIN")) {
                SaRouter.stop();
            }
            if (Objects.nonNull(ignoreAuthClass) && ignoreAuthClass.type().equals("LOGIN")) {
                SaRouter.stop();
            }
        }
        for (IgnoreHandler v :
                valuesByBeanType) {
            if (v.checkAfterIgnoreLogin(handler)) {
                SaRouter.stop();
            }
        }
        StpUtil.checkLogin();
    }
}