/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.satoken.core.util;

import cn.dev33.satoken.stp.StpUtil;
import cn.jrack.core.constant.SystemConstant;
import cn.jrack.springboot.satoken.core.StUserInfo;
import java.time.LocalDateTime;

public class SaTokenUtils {
    private static final String LOGIN_ID = SystemConstant.NAME + "_token_login_id_";

    public static boolean isLogin() {
        return StpUtil.isLogin();
    }

    public static Object getLoginId() {
        return StpUtil.getLoginId();
    }

    public static void login(Object loginId, StUserInfo loginUserInfo) {
        StpUtil.login((Object)loginId);
        loginUserInfo.setLastLoginTime(LocalDateTime.now());
        StpUtil.getSession((boolean)false).set(LOGIN_ID + StpUtil.getLoginId(), (Object)loginUserInfo);
    }

    public static StUserInfo getLoginUserInfo(Object loginId) {
        return (StUserInfo)StpUtil.getSession((boolean)false).get(LOGIN_ID + loginId);
    }

    public static StUserInfo getLoginUserInfo() {
        return (StUserInfo)StpUtil.getSession((boolean)false).get(LOGIN_ID + StpUtil.getLoginId());
    }

    public static StUserInfo getLoginUserInfo(String token) {
        return (StUserInfo)StpUtil.getSession((boolean)false).get(LOGIN_ID + StpUtil.getTokenValueByLoginId((Object)token));
    }

    public static void logout() {
        StpUtil.logout((Object)(LOGIN_ID + StpUtil.getLoginId()));
        StpUtil.getSession((boolean)false).delete(LOGIN_ID + StpUtil.getLoginId());
    }

    public static void checkLogin() {
        StpUtil.checkLogin();
    }

    public static String getTokenValue() {
        return StpUtil.getTokenValue();
    }

    public static void main(String[] args) {
        SaTokenUtils.login(10001, new StUserInfo());
        System.out.println(SaTokenUtils.getTokenValue());
    }
}

