package cn.jrack.springboot.redis.config;


import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;

import org.springframework.data.redis.serializer.StringRedisSerializer;

import javax.annotation.Resource;
import java.io.Serializable;


@Configuration
@EnableConfigurationProperties({SpringRedisProperties.class})
@ComponentScan("cn.jrack.springboot.redis.core.*")
public class JrackRedisAutoConfiguration {


    @Resource
    private SpringRedisProperties springRedisProperties;


    @Bean
    public RedisTemplate<String, Serializable>
    redisTemplate(LettuceConnectionFactory connectionFactory) {
        connectionFactory.setDatabase(springRedisProperties.getDatabase());
        RedisTemplate<String, Serializable> redisTemplate = new RedisTemplate<>();
        redisTemplate.setKeySerializer(new StringRedisSerializer());
        redisTemplate.setValueSerializer(new GenericJackson2JsonRedisSerializer());
        redisTemplate.setConnectionFactory(connectionFactory);
        return redisTemplate;
    }



}
