/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.redis.core.util;

import cn.hutool.extra.spring.SpringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisUtil {
    private static RedisTemplate<String, Object> redisTemplate = (RedisTemplate)SpringUtil.getBean((String)"redisTemplate", RedisTemplate.class);

    private RedisUtil() {
    }

    public static boolean expire(String key, long timeout) {
        return RedisUtil.expire(key, timeout, TimeUnit.SECONDS);
    }

    public static boolean expire(String key, long timeout, TimeUnit unit) {
        Boolean ret = redisTemplate.expire((Object)key, timeout, unit);
        return ret != null && ret != false;
    }

    public static boolean del(String key) {
        Boolean ret = redisTemplate.delete((Object)key);
        return ret != null && ret != false;
    }

    public static long del(Collection<String> keys) {
        Long ret = redisTemplate.delete(keys);
        return ret == null ? 0L : ret;
    }

    public static void set(String key, Object value) {
        redisTemplate.opsForValue().set((Object)key, value);
    }

    public static void set(String key, Object value, long timeout) {
        redisTemplate.opsForValue().set((Object)key, value, timeout, TimeUnit.SECONDS);
    }

    public static Object get(String key) {
        return redisTemplate.opsForValue().get((Object)key);
    }

    public static void hPut(String key, String filed, Object value) {
        redisTemplate.opsForHash().put((Object)key, (Object)filed, value);
    }

    public static void hPutAll(String key, Map<String, Object> filedMap) {
        redisTemplate.opsForHash().putAll((Object)key, filedMap);
    }

    public static Object hGet(String key, String filed) {
        return redisTemplate.opsForHash().get((Object)key, (Object)filed);
    }

    public static List<Object> hMultiGet(String key, Collection<Object> fileds) {
        return redisTemplate.opsForHash().multiGet((Object)key, fileds);
    }

    public static long sSet(String key, Object ... values) {
        Long count = redisTemplate.opsForSet().add((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long sDel(String key, Object ... values) {
        Long count = redisTemplate.opsForSet().remove((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long lPush(String key, Object value) {
        Long count = redisTemplate.opsForList().leftPush((Object)key, value);
        return count == null ? 0L : count;
    }

    public static long rPush(String key, Object value) {
        Long count = redisTemplate.opsForList().rightPush((Object)key, value);
        return count == null ? 0L : count;
    }

    public static long lPushAll(String key, Collection<Object> values) {
        Long count = redisTemplate.opsForList().leftPushAll((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long lPushAll(String key, Object ... values) {
        Long count = redisTemplate.opsForList().leftPushAll((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long rPushAll(String key, Collection<Object> values) {
        Long count = redisTemplate.opsForList().rightPushAll((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long rPushAll(String key, Object ... values) {
        Long count = redisTemplate.opsForList().rightPushAll((Object)key, values);
        return count == null ? 0L : count;
    }

    public static List<Object> listGetRange(String key, int start, int end) {
        return redisTemplate.opsForList().range((Object)key, (long)start, (long)end);
    }

    public static Object listGetL(String key) {
        return redisTemplate.opsForList().leftPop((Object)key);
    }

    public static Object listGetR(String key) {
        return redisTemplate.opsForList().rightPop((Object)key);
    }
}

