/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.redis.config;

import cn.jrack.springboot.redis.config.SpringRedisProperties;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableConfigurationProperties(value={SpringRedisProperties.class})
public class JkRedisAutoConfigure {
    @Resource
    private SpringRedisProperties springRedisProperties;

    @Bean
    public RedisTemplate<String, Serializable> redisTemplate(LettuceConnectionFactory connectionFactory) {
        connectionFactory.setDatabase(this.springRedisProperties.getDatabase());
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.setConnectionFactory((RedisConnectionFactory)connectionFactory);
        return redisTemplate;
    }
}

