/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.mybatis.core.type;

import cn.hutool.core.lang.Assert;
import cn.hutool.extra.spring.SpringUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.jasypt.encryption.StringEncryptor;

public class EncryptTypeHandler
extends BaseTypeHandler<String> {
    private static StringEncryptor encryptor;

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, EncryptTypeHandler.getEncryptor().encrypt(parameter));
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        return EncryptTypeHandler.decrypt(value);
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        return EncryptTypeHandler.decrypt(value);
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        return EncryptTypeHandler.decrypt(value);
    }

    private static String decrypt(String value) {
        if (value == null) {
            return null;
        }
        return EncryptTypeHandler.getEncryptor().decrypt(value);
    }

    public static String encrypt(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        return EncryptTypeHandler.getEncryptor().encrypt(rawValue);
    }

    private static StringEncryptor getEncryptor() {
        if (encryptor != null) {
            return encryptor;
        }
        encryptor = (StringEncryptor)SpringUtil.getBean(StringEncryptor.class);
        Assert.notNull((Object)encryptor, (String)"StringEncryptor \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return encryptor;
    }
}

