package cn.jrack.springboot.mybatis.core.handler;


import cn.jrack.springboot.mybatis.core.entity.BasicEntity;

import cn.jrack.springboot.satoken.core.util.SaTokenUtils;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 通用参数填充实现类
 * <p>
 * 如果没有显式的对通用参数进行赋值，这里会对通用参数进行填充、赋值
 *
 * @author hexiaowu
 */
public class DefaultDBFieldHandler implements MetaObjectHandler {

    @Override
    public void insertFill(MetaObject metaObject) {
        if (Objects.nonNull(metaObject) && metaObject.getOriginalObject() instanceof BasicEntity) {
            BasicEntity basicEntity = (BasicEntity) metaObject.getOriginalObject();

            LocalDateTime current = LocalDateTime.now();
            // 创建时间为空，则以当前时间为插入时间
            if (Objects.isNull(basicEntity.getCreatedTime())) {
                basicEntity.setCreatedTime(current);
            }
            // 更新时间为空，则以当前时间为更新时间
            if (Objects.isNull(basicEntity.getUpdatedTime())) {
                basicEntity.setUpdatedTime(current);
            }

            String userId = SaTokenUtils.getLoginId().toString();
            // 当前登录用户不为空，创建人为空，则当前登录用户为创建人
            if (Objects.nonNull(userId) && Objects.isNull(basicEntity.getCreatedBy())) {
                basicEntity.setCreatedBy(userId);
            }
            // 当前登录用户不为空，更新人为空，则当前登录用户为更新人
            if (Objects.nonNull(userId) && Objects.isNull(basicEntity.getUpdatedBy())) {
                basicEntity.setUpdatedBy(userId);
            }
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        // 更新时间为空，则以当前时间为更新时间
        Object modifyTime = getFieldValByName("updated_time", metaObject);
        if (Objects.isNull(modifyTime)) {
            setFieldValByName("updated_time", LocalDateTime.now(), metaObject);
        }

        // 当前登录用户不为空，更新人为空，则当前登录用户为更新人
        Object modifier = getFieldValByName("update_by", metaObject);
        String userId = SaTokenUtils.getLoginId().toString();
        if (Objects.nonNull(userId) && Objects.isNull(modifier)) {
            setFieldValByName("update_by", userId, metaObject);
        }
    }
}
