
package cn.jrack.metadata.driver;



import cn.jrack.metadata.convert.ITypeConvert;
import cn.jrack.metadata.convert.MySqlTypeConvert;
import cn.jrack.metadata.query.MySqlQuery;
import cn.jrack.metadata.query.IDBQuery;
import java.util.HashMap;
import java.util.Map;

/**
 * MysqlDriver
 *
 * @author ZhaoYang
 * @since 2021/7/20 14:06
 **/
public class MySqlDriver extends AbstractJdbcDriver {

    @Override
    public IDBQuery getDBQuery() {
        return new MySqlQuery();
    }

    @Override
    public ITypeConvert getTypeConvert() {
      return new MySqlTypeConvert();
    }

    @Override
    public String getType() {
        return "MySql";
    }

    @Override
    public String getName() {
        return "MySql数据库";
    }

    @Override
    public String getDriverClass() {
        return "com.mysql.cj.jdbc.Driver";
    }

    @Override
    public Map<String, String> getFlinkColumnTypeConversion() {
        HashMap<String, String> map = new HashMap<>();
        map.put("VARCHAR", "STRING");
        map.put("TEXT", "STRING");
        map.put("INT", "INT");
        map.put("DATETIME", "TIMESTAMP");
        return map;
    }
}
