
package cn.jrack.metadata.query;

/**
 * MySqlQuery
 *
 * @author ZhaoYang
 * @since 2021/7/20 14:01
 **/
public class DmQuery extends AbstractDBQuery {

    @Override
    public String schemaAllSql() {
        return "show databases";
    }

    @Override
    public String tablesSql(String schemaName) {
//        return "select TABLE_NAME AS `NAME`,TABLE_SCHEMA AS `Database`,TABLE_COMMENT AS COMMENT,TABLE_CATALOG AS `CATALOG`"
//                + ",TABLE_TYPE AS `TYPE`,ENGINE AS `ENGINE`,CREATE_OPTIONS AS `OPTIONS`,TABLE_ROWS AS `ROWS`"
//                + ",CREATE_TIME,UPDATE_TIME from information_schema.tables"
//                + " where TABLE_SCHEMA = '" + schemaName + "'";

        return "\n" +
                "SELECT \n" +
                "AA.TABLE_NAME AS NAME,\n" +
                "AA.OWNER AS DATABASE,\n" +
                "BB.COMMENTS AS \"COMMENT\",\n" +
                "NULL AS CATALOG,\n" +
                "BB.TABLE_TYPE AS TYPE,\n" +
                "NULL AS ENGINE,\n" +
                "NULL AS OPTIONS,\n" +
                "NULL AS \"ROWS\",\n" +
                "NULL AS CREATE_TIME,\n" +
                "NULL AS UPDATE_TIME\n" +
                " FROM dba_tables AS AA\n" +
                "\tINNER JOIN ALL_TAB_COMMENTS AS BB\n" +
                "\t\tON AA.TABLE_NAME = BB.TABLE_NAME \n" +
                "\t\tWHERE AA.OWNER='PJYDBA'\n";


    }

    @Override
    public String columnsSql(String schemaName, String tableName) {

//        return "select COLUMN_NAME,DATA_TYPE,COLUMN_COMMENT,COLUMN_KEY,EXTRA AS AUTO_INCREMENT"
//                + ",COLUMN_DEFAULT,IS_NULLABLE,NUMERIC_PRECISION,NUMERIC_SCALE,CHARACTER_SET_NAME"
//                + ",COLLATION_NAME,ORDINAL_POSITION from INFORMATION_SCHEMA.COLUMNS "
//                + "where TABLE_SCHEMA = '" + schemaName + "' and TABLE_NAME = '" + tableName + "' "
//                + "order by ORDINAL_POSITION";

        return "SELECT \n" +
                "AA.COLUMN_NAME,\n" +
                "AA.DATA_TYPE，\n" +
                "BB.COMMENTS AS COLUMN_COMMENT,\n" +
                "AA.COLUMN_ID AS COLUMN_KEY,\n" +
                "NULL AS \"AUTO_INCREMENT\",\n" +
                "DATA_DEFAULT AS COLUMN_DEFAULT,\n" +
                "NULLABLE AS IS_NULLABLE,\n" +
                "NULL AS NUMERIC_PRECISION,\n" +
                "NULL AS NUMERIC_SCALE,\n" +
                "AA.CHARACTER_SET_NAME,\n" +
                "NULL AS COLLATION_NAME,\n" +
                "NULL AS ORDINAL_POSITION\n" +
                "\n" +
                "\n" +
                " FROM DBA_TAB_COLUMNS AS AA\n" +
                "\t\tLEFT JOIN ALL_COL_COMMENTS AS BB \n" +
                "\t\tON AA.TABLE_NAME = BB.TABLE_NAME  AND AA.COLUMN_NAME=BB.COLUMN_NAME\n" +
                "\t\tWHERE AA.OWNER='" + schemaName + "' AND  AA.TABLE_NAME='" + tableName + "'\n" +
                "\t\tORDER BY AA.COLUMN_ID";
    }

    @Override
    public String schemaName() {
        return "Database";
    }

}
