
package cn.jrack.metadata.driver;


import cn.jrack.metadata.convert.DmTypeConvert;
import cn.jrack.metadata.convert.ITypeConvert;
import cn.jrack.metadata.query.IDBQuery;
import cn.jrack.metadata.query.DmQuery;

import java.util.HashMap;
import java.util.Map;

/**
 * MysqlDriver
 *
 * @author ZhaoYang
 * @since 2021/7/20 14:06
 **/
public class DmDriver extends AbstractJdbcDriver {

    @Override
    public IDBQuery getDBQuery() {
        return new DmQuery();
    }

    @Override
    public ITypeConvert getTypeConvert() {
      return new DmTypeConvert();
    }

    @Override
    public String getType() {
        return "DM";
    }

    @Override
    public String getName() {
        return "DM数据库";
    }

    @Override
    public String getDriverClass() {
        return "dm.jdbc.driver.DmDriver";
    }

    @Override
    public Map<String, String> getFlinkColumnTypeConversion() {
        HashMap<String, String> map = new HashMap<>();
        map.put("VARCHAR", "STRING");
        map.put("TEXT", "STRING");
        map.put("INT", "INT");
        map.put("DATETIME", "TIMESTAMP");
        return map;
    }
}
